/**
 * @author Amit Gupta
 */
Ext.define('Academia.view.filemanagement.FileAttachmentsForm',{
	extend: 'Ext.window.Window',
	alias: 'widget.fileattachmentsform',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '60%',
	width: '60%',
	title:getFileManagementTranslation('FILE_ATTACHMENTS'),
	items: [{
		xtype:'form',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'fileNumber',
				itemId:'fileNumber',
				fieldLabel: getServiceRequestTranslation('FILE_NO'),
			},{
				xtype:'displayfield',
				name:'fileOwner',
				itemId:'fileOwner',
				fieldLabel:getFileManagementTranslation('FILE_OWNER')
			}]
		}]
	},{
		xtype: 'grid',
		itemId : 'periodGridWin',
		store:'filemanagement.FileDocumentByFileInfoStore',
		frame: false,
		border:true,
		selType:'checkboxmodel',
		autoScroll: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		features: [{
			ftype: 'summary',
			showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		}],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'filemanagement.FileDocumentByFileInfoStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		tbar: [{
			xtype: 'button',
			itemId: 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip: getCommonTranslation('DELETE'),
			iconCls: 'icon-Delete',
			cls:'iconDelete'
		},{
			xtype: 'button',
			text: getFileManagementTranslation('DOWNLOAD_DOCUMENT'),
			itemId: 'downloadAllDocuments',
			buttonAlign: 'left',
		}],
		columns: [/*{
			header:  getFileManagementTranslation('ID'),
			dataIndex: 'documentId',
			flex:.1,
			sortable:true,
			hidden:true
		},{
			header:  getFileManagementTranslation('PATH'),
			dataIndex: 'path',
			flex:.1,
			sortable:true,
			hidden:true
		},*/{
			header:  getFileManagementTranslation('DOCUMENT_NAME'),
			dataIndex: 'documentName',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(value){
					return "<a href='#'>"+value+"</a>";
				}
			}
		},{
			header:  getFileManagementTranslation('UPLOADED_BY'),
			dataIndex: 'printName',
			flex:.1,
			sortable:true
		},{
			header:  getFileManagementTranslation('UPLOAD_DATE'),
			dataIndex: 'uploadDate',
			flex:.1,
			sortable:true,
			renderer:function(date) {
				return dateRender(date);
			}
		}] 	
	}]
});
