/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.filemanagement.FileInformationForm', {   
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.fileinformationform',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,	
	method : 'POST',
	frame: true,
	autoScroll:false,
	modal:true,
	width:'100%',
	title:getFileManagementTranslation('FILE_INFORMATION'),
	plugins : "formlabelrequired",
	items: [{
		xtype:'form',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			plugins:"formlabelrequired",
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'assignedUserName',
				itemId:'assignedUserName',
				fieldLabel: getFileManagementTranslation('ASSIGNED_BY'),
			},{
				xtype:'displayfield',
				name:'assignmentDate',
				itemId:'assignmentDate',
				fieldLabel:getFileManagementTranslation('ASSIGNED_DATE')
			},{
				xtype:'displayfield',
				name:'dueDate',
				itemId:'dueDate',
				fieldLabel:getFileManagementTranslation('DUE_DATE')
			}]
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style:{
			marginLeft:'10px'
		},
		items:[{

			xtype: 'datefield',
			name: 'receivedDate',
			itemId:'receivedDate',
			//--submitFormat:CONSTANTS.DATE_FORMAT,
			//vtype: 'daterange',
			//endDateField: 'dueDate',
//			value:new Date(),
			editable:false,
			allowBlank:true,
			fieldLabel: getFileManagementTranslation('FILE_RECEIVED_DATE'),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		},{
			xtype: 'customcombobox',
			name:'fileHandoverById',
			itemId:'fileHandoverById',
			fieldLabel : getFileManagementTranslation('FILE_HANDOVER_BY'),
			store: 'criteriabuilder.userquicksearch.QuickSearchName',
			msgTarget: 'qtip',
			valueField: 'id',
			displayField: 'valueCode',
			allowBlank:false,
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
		},{
		xtype: 'checkboxfield',
		width: 'auto',
		style:{
			marginLeft:'10px'
		},
		labelAlign: 'right',
		itemId:'returnClarification',
		boxLabel: getFileManagementTranslation('RETURN_FORCLARIFICATION'),
		name: 'returnClarification',
		inputValue : true
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style:{
			marginLeft:'10px'
		},
		items: [{
			xtype: 'textarea',
			name:'returnReason',
			itemId:'returnReason',
			width: 460,
			maxLength : 250,
			hidden:true,
			fieldLabel: getFileManagementTranslation('RETURN_REASON')
		}]
	},{

		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		style:{
			marginLeft:'10px'
		},
		items : [{
			xtype: 'datefield',
			name: 'returningDate',
			itemId:'returningDate',
			//--submitFormat:CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			endDateField: 'resubmissionDueDate',
			editable:false,
			allowBlank:true,
			hidden:true,
			fieldLabel:getFileManagementTranslation('RETURNING_DATE')
		},{
			xtype: 'datefield',
			name: 'resubmissionDueDate',
			itemId:'resubmissionDueDate',
			//--submitFormat:CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			hidden:true,
			startDateField: 'returningDate',
			editable:false,
			fieldLabel:getFileManagementTranslation('DUE_DATE_FOR_RESUBMISSION')
		}]
	},{
		xtype:'fieldcontainer',
		//width:'100%',
		//cls:'windowBtnPos',
		style:{
			marginLeft:'10px'
		},
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getFeeAndPaymentCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			//itemId: 'programFormCancelButtonId',
			itemId: 'resetBtn1',
			//hidden:true,
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
