/**
 * 
 */
Ext.define('Academia.view.hostel.hostelApplicationSetup.HostelSetupAddMappingProgramGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.hostelSetupAddMappingProgramGrid',
	title : getCommonTranslation('PROGRAM'),
	store: 'manageCeremony.CeremonyProgramMappingStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	 dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            store: 'manageCeremony.CeremonyProgramMappingStore',
	            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	            displayInfo: true
	        }]
	    }],
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programsearchcombo',
		itemId:'programsearchcombo',
		store: 'feeandpayment.FindAllProgramsByALId',
		valueField: 'id',
		displayField: 'valueCode',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'searchText',
		queryMode: 'remote',
		width:226,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{valueCode}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex : 'codeValue',
		flex : 1	 
	}]
});