/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.hostel.hostelapplication.ResidenceAllocationWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.residenceAllocationWin',
	title:getHostelTranslation('RESIDENCE_ALLOCATION'),
	frame: true,
	autoScroll:false,
	modal:true, 
	height: 200,
	width: '35%',
	items: [{
        xtype: 'form',
        plugins : "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
    			xtype: 'customcombobox',
    			name:'hostelCode',
    			itemId:'hostelCode',
    			store:'hostel.managehostel.hostel.HostelCodeName',
    			fieldLabel:getHostelTranslation('HOSTEL_CODE_NAME'),
    			width:226,
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'hostelnameorcode',
    			minChars:3,
    			typeAhead:false,
    			allowBlank:false,
    			hideTrigger:false,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			triggerAction: '',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{code}/{printName}'  +
    	                    '</div>';
    	                }
    	            }
    		}, {

           	 xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ALLOCATED_BY'),
                itemId: 'allocatedBy',
                name: 'allocatedBy',
                enableKeyEvents: true,
                vtype: 'NospaceAsInput',
                store:'hostel.managehostel.hostel.HostelAllocatedStore',
    			width:226,
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'nameOrCode',
    			minChars:3,
    			typeAhead:false,
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			triggerAction: '',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			forceSelection:true,
    			allowBlank:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'residenceSubmitBtn',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'residenceCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]     
});