/**
 * 
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.hostel.manageallocation.manageallocationuserwise.HostelDocumentGrid', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.hosteldocumentgrid',
    store: 'hostel.roomallocation.userwise.HostelDocumentStore',
    border: true,
    enableColumnHide: false,
    //autoScroll:true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    /*dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'personinfo.common.documents.OnlineDocumentStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],*/
	   
    columns: [{
        header: getPersonModuleTranslation('DOCUMENTS_NAME'),
        dataIndex: 'name',
        itemId: 'documentTypeItem',
        sortable: true,
        flex: .2,
        renderer: function(value, metadata, record) {
            var msg = "";
            if (!isNullOrEmpty(record.data.isPreDefined) && record.data.isPreDefined) {
                if (!isNullOrEmpty(value)) {
                    msg = '<a href="#">' + columnObjRender(value, "value") + '</a>';
                }
            } else {
                if (!isNullOrEmpty(record.raw.name)) {
                    msg = '<a href="#">' + record.raw.name + '</a>';
                }
            }
            return msg;
        }
    },  {
        header: getCommonTranslation('HW_SUBMISSION_DATE'),
        dataIndex: 'submissionDate',
        sortable: true,
        flex: .2,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'documentStatusCSM',
        sortable: true,
        flex: .2,
        renderer: function(value, metadata, record) {
            if (!isNullOrEmpty(value)) {
               return  getCommonTranslation(value.value) ;
               }
            }
    }]
});