/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.managehostel.ManageHostelGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managehostelgrid',
	store : 'hostel.managehostel.hostel.ManageHostelGrid',
	title: getHostelTranslation('LIST_OF_HOSTELS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managehostelstructurenew':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.managehostel.hostel.ManageHostelGrid',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns: [{
		header : getHostelTranslation('HOSTEL_CODE'),
		dataIndex : 'hostelCode',
		flex:1
	},{
		header : getHostelTranslation('HOSTEL_NAME'),
		dataIndex : 'hostelName',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_BUILDINGS'),
		dataIndex : 'noOfBuilings',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getHostelTranslation('MANAGER'),
		dataIndex : 'managerPrintName',
		flex:1,
		renderer:function(value) {
			return value;
		}
	},{
		header : getHostelTranslation('START_DATE'),
		dataIndex : 'startDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	},{
		header : getHostelTranslation('RESTRICTION_TYPE'),
		dataIndex : 'restrictionType',
		flex:1,
		sortable: true
	},{
		header : getHostelTranslation('HOSTEL_LEVEL'),
		dataIndex : 'hostelLevel',
		sortable: true,
		flex:1
	},{
		header : getHostelTranslation('HOSTEL_TYPE'),
		dataIndex : 'hostelType',
		sortable: true,
		flex:1
	},{
		header : getHostelTranslation('CLUSTER_CODE'),
		dataIndex : 'clusterCode',
		sortable: true,
		flex:1
	},{
		header : getHostelTranslation('HOSTEL_CATEGORY'),
		dataIndex : 'hostelCategory',
		sortable: true,
		flex:1
	},{
		header : getHostelTranslation('WARDEN'),
		dataIndex : 'wardenPrintName',
		sortable: true,
		flex:1
	}
	]
});