/**
 * Dharmendra.p
 */
Ext.define('Academia.view.hostel.managehostel.building.FloorsCountList', {
	extend: 'Ext.grid.Panel',
    alias : 'widget.floorscountlist',
    store : 'hostel.managehostel.building.FloorsCountList',
    border: true,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.managehostel.building.FloorsCountList',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    columns : [{
		header :getHostelTranslation('FLOOR_NO'),
		dataIndex : 'code',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_ROOMS'),
		dataIndex : 'count',
		flex:1
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}]
});
