Ext.define('Academia.view.hostel.reports.hostelfeereports.HostelReceiptDetails', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelreceiptdetails',
	store :'hostel.reports.hostelfeereport.HostelReceiptDetails',
	title: getHostelTranslation('LIST_OF_ROOMS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.reports.hostelfeereport.HostelReceiptDetails',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header : getHostelTranslation('FEE_PLAN_NAME'),
		dataIndex : 'feePlanName',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_ID'),
		dataIndex : 'billNo',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('BILLABLE_AMOUNT'),
		dataIndex : 'billBillableAmount',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
		dataIndex : 'receiptNo',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_AMOUNT_SETTLED'),
		dataIndex : 'receiptAmountSettled',
		flex:1,
	},{
		header : getFeeAndPaymentCommonTranslation('RECEIPT_DATE'),
		dataIndex : 'receiptDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
		
	},{
		header : getFeeAndPaymentCommonTranslation('ADJUSTMENT_DATE'),
		dataIndex : 'adjustmentDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
		
	}]
});