/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.hrm.biometric.BMIForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.bmiform',
	autoScroll: true,
	bodyPadding:'10 10 10 10',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'machineCode',
			itemId:'machineIdItemId',
			fieldLabel : getCommonTranslation('BMI_MACHINE_ID'),
			allowBlank:false,
			maxLength: 40
		},{
			xtype : 'textfield',
			name : 'machineName',
			itemId:'machineNameItemId',
			fieldLabel : getCommonTranslation('BMI_MACHINE_NAME'),
			allowBlank:false,
			maxLength: 45
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name: 'machineIP',
			itemId: 'machineIPItemId',
			fieldLabel : getCommonTranslation('BMI_MACHINE_IP'),
			maxLength: 20,
			regex: /^[\d.]+$/,
			allowBlank:false
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('ACTION'),
			name:'action',
			itemId : 'actionItemId',
			store: 'hrm.biometric.BMIActionStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank:false,
			listeners:{
				blur:function(field){
					//empty blur event is written for V2D-411515
				}
			}
		}]

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'checkboxfield',
			name: 'isActive',
			itemId:'activeItemId',
			boxLabel: getCommonTranslation('ACTIVE'),
			width: 'auto',
			//boxLabelAlign:'before',
			labelAlign: 'right'/*,
			fieldStyle:{
				marginLeft:'50px'
			}*/
		},{ 
			xtype: 'tbspacer', 
			width: 166 
		},{
			xtype: 'checkboxfield',
			name: 'isDefault',
			itemId:'defaultItemId',
			boxLabel: getCommonTranslation('IS_DEFAULT'),
			width: 'auto',
			//boxLabelAlign:'before',
			labelAlign: 'right'/*,
			fieldStyle:{
				marginLeft:'50px'
			}*/
		}]
	},{
		xtype: 'panel',
		width:'100%',
		cls: 'panelNoSpace',
		items: [{
			xtype : 'bmiformresourcegrid',
			margin: '8 0 25 0'
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [{
			xtype : 'button',
			text : getCommonTranslation("SAVE") ,
			itemId : 'submitBtnBMI',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			itemId: 'resetBtnBMI',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
