/**
 * @author Santosh Sahu
 * 
 */
Ext.define('Academia.view.kohalibrarytransaction.LibraryBranchAndCategoryFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.librarybranchandcategoryfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'vbox',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items :[{
	            xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	            name: 'ACAD_LOC_ID',
	            itemId:'academyLocationCombo',
	            store: 'user.UserAcademyLocationStore',
	            displayField: 'value',
	            valueField: 'id',
	            typeAhead : true,
	            forceSelection:true,
	            hideTrigger:false,
	            queryMode: 'local',	 
	            allowBlank:true,
	    	    triggerAction: 'all',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  /*listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								var selectionstagereportSearchField = Ext.ComponentQuery.query('selectionstagereportfilter')[0];
								if(isNullOrEmpty(selectionstagereportSearchField.down('#programId').getValue()))
									{
									selectionstagereportSearchField.down('#searchFilterBtn').setDisabled(true);	
									}
								
							}
						},*/
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	        },{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('LIBRARY'),		
				name : 'library',
				itemId : 'library',
				displayField : 'code',
				valueField : 'value',
				store:'kohalibrarytransation.LibraryBranchStore',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				width:226
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PATRON_CATEGORY'),
				name:'category',
				itemId: 'category',
				displayField: 'code',
				valueField: 'value',
				store:'kohalibrarytransation.LibraryCategoryStore',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				width:226
			}]
		},],
		},{
			xtype: 'fieldcontainer',
			width: 'auto',

			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'libraryConfigurationSearchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'libraryConfigurationResetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
