/**
 * @author Deepak S
 */
Ext.define('Academia.view.leavemanagement.leavecreditsetting.LeaveCreditSettingGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.leavecreditsettinggrid',
    store: 'leavemanagement.leavecreditsetting.LeaveCreditSettingGridStore',
    border: true,
    refreshStoreData:true,
    frame:false,
    title:getCommonTranslation('HR_CREDIT_SETTINGS_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'leavecreditsettingfilter':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'leavemanagement.leavecreditsetting.LeaveCreditSettingGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}/*, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    
   }*/],
    columns: [{
        header: getCommonTranslation('LEAVE_TYPE'),
        dataIndex: 'hrLeaveType',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)) {
        		return value.value;
        	} 
        	return '';
        }
    }, {
        header: getCommonTranslation('HR_CREDIT_SETTING_CODE'),
        dataIndex: 'code',
        flex:.3,
        sortable: true
    }, {
        header: getCommonTranslation('HR_CREDIT_TYPE'),
        dataIndex: 'hrLeaveCreditType',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                        
		}
    },{
        header: getCommonTranslation('CREDIT_PERIOD'),
        dataIndex: 'leaveCreditPeriod',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                        
		}
    },{
        header: getCommonTranslation('HR_CREDIT_BALANCE'),
        dataIndex: 'creditBalance',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('HR_MAX_BALANCE'),
        dataIndex: 'maxCreditBalance',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('HR_LEAVE_LAPSE'),
        dataIndex: 'isLeaveLapse',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value) && value) {
        		return 'Yes';
        	}
        	else if(!isNullOrEmpty(value) && !value){
        		return 'No';
        	}
        	return '';
        }
    },{
        header: getCommonTranslation('HR_LEAVE_CARRY_FORWARD'),
        dataIndex: 'isLeaveCarryForward',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value) && value) {
        		return 'Yes';
        	}
        	else if(!isNullOrEmpty(value) && !value){
        		return 'No';
        	}
        	return '';
        }
    },{
        header: getCommonTranslation('HR_LEAVE_ENCASHMENT'),
        dataIndex: 'isLeaveEncashment',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value) && value) {
        		return 'Yes';
        	}
        	else if(!isNullOrEmpty(value) && !value){
        		return 'No';
        	}
        	return '';
        }
    }]
});