/**
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.leavemanagement.report.LMEmployeeLeaveReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmemployeeleavereportgrid',
    store: 'leavemanagement.report.LMEmployeeLeaveReportGridStore',
    title: getPersonModuleTranslation('HRM_EMPLOYEE_LEAVE_REPORT'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.report.LMEmployeeLeaveReportGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [],
    columns: [{
        header: getPersonModuleTranslation('EMPLOYEE_ID'),
        dataIndex: 'code',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'name',
        flex: 1,
        sortable: true,
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION_NAME'),
        dataIndex: 'academyLocation',
        flex: 1,
        sortable: true,
    },{
        header: getCommonTranslation('LEAVE_TYPE'),
        dataIndex: 'hrLeaveTypeIDCode',
        flex: 1,
        renderer:function(val) {
			return val.value;
		}
    },{
    	header: getPersonModuleTranslation('CLAIM_DATE'),
    	dataIndex: 'claimDate',
    	flex: 1,
    	hidden:true,
    	renderer:function(val) {
    		if(!isNullOrEmpty(val)){
    			return dateRender(val);
			}else{
				return "";
			}
    	}
    }, {
    	header: getPersonModuleTranslation('REQUEST_DATE'),
    	dataIndex: 'requestDate',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header: getPersonModuleTranslation('FROM_DATE'),
    	dataIndex: 'fromDate',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header: getPersonModuleTranslation('To_Date'),
    	dataIndex: 'toDate',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1
    }, {
        header: getCommonTranslation('LM_TIMELINE'),
        dataIndex: 'view',
        flex: 1,
        sortable: true,
        renderer: function(value, metadata, record) {
    		var msg = '<a href="#">' + "View" + '</a>';
    		return msg;
    	}
    },{
		text : getPersonModuleTranslation('DEPARTMENT'),
        dataIndex: 'department',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('SUB_DEPARTMENT'),
        dataIndex: 'subDepartment',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('EMAIL_ID'),
        dataIndex: 'emailId',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('MOBILE_NUMBER'),
        dataIndex: 'mobileNumber',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('HRM_TOTAL_DAYS'),
        dataIndex: 'totalDays',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LMAS_LEAVE_REASON_REMARK'),
        dataIndex: 'reason',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LMAS_WORK_HANDED_OVER_TO'),
        dataIndex: 'alternateEmpNames',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LAST_UPDATED_ON'),
		dataIndex: 'updatedOn',
		hidden:true,
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		text : getPersonModuleTranslation('LAST_UPDATED_BY'),
        dataIndex: 'updatedBy',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL1_APPROVER'),
        dataIndex: 'reqApprover1',
		hidden:true,
		flex:1,
		renderer:function(val) {
			if(!isNullOrEmpty(val)){
				return val.value;
			}else{
				return ""
			}
		}
	},{
		text : getPersonModuleTranslation('LEVEL1_ACTION'),
        dataIndex: 'approver1Action',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL1_REMARK'),
        dataIndex: 'approver1Remark',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL1_ACTION_DATE'),
        dataIndex: 'approver1ActionDate',
		hidden:true,
		flex:1,
		 renderer:function(date) {
 			return dateRender(date);
 		}
	},{
		text : getPersonModuleTranslation('LEVEL2_APPROVER'),
        dataIndex: 'reqApprover2',
		hidden:true,
		flex:1,
		renderer:function(val) {
			if(!isNullOrEmpty(val)){
				return val.value;
			}else{
				return ""
			}
		}
	},{
		text : getPersonModuleTranslation('LEVEL2_ACTION'),
        dataIndex: 'approver2Action',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL2_REMARK'),
        dataIndex: 'approver2Remark',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL2_ACTION_DATE'),
		dataIndex: 'approver2ActionDate',
		hidden:true,
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		text : getPersonModuleTranslation('LEVEL3_APPROVER'),
		dataIndex: 'reqApprover3',
		hidden:true,
		flex:1,
		renderer:function(val) {
			if(!isNullOrEmpty(val)){
				return val.value;
			}else{
				return ""
			}
		}
	},{
		text : getPersonModuleTranslation('LEVEL3_ACTION'),
        dataIndex: 'approver3Action',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL3_REMARK'),
        dataIndex: 'approver3Remark',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL3_ACTION_DATE'),
		dataIndex: 'approver3ActionDate',
		hidden:true,
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		text : getPersonModuleTranslation('LEVEL4_APPROVER'),
		dataIndex: 'reqApprover4',
		hidden:true,
		flex:1,
		renderer:function(val) {
			if(!isNullOrEmpty(val)){
				return val.value;
			}else{
				return ""
			}
		}
	},{
		text : getPersonModuleTranslation('LEVEL4_ACTION'),
        dataIndex: 'approver4Action',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL4_REMARK'),
        dataIndex: 'approver4Remark',
		hidden:true,
		flex:1
	},{
		text : getPersonModuleTranslation('LEVEL4_ACTION_DATE'),
		dataIndex: 'approver4ActionDate',
		hidden:true,
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	}],
});