/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.manageCeremony.ManageCeremonyGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageCeremonyGrid',
	store : 'manageCeremony.ManageCeremonyGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
	    headerFix: true,
	    portalIdsWithStructure: {
	    'manageCeremonyStructure':1
	 }},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'manageCeremony.ManageCeremonyGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	isGridConfigurable: true,
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		disabled:true,
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getCommonTranslation('APPLY_TO'),
			itemId: 'btnApplyTo',
		}],
		listeners: { click: function() { this.showMenu(); } }
	},'->'],
	columns: [{
		header : getCommonTranslation('CEREMONY_ID'),
		dataIndex : 'ceremonyId',
		flex:1
	},{
		header : getCommonTranslation('CEREMONY_NAME'),
		dataIndex : 'ceremonyName',
		flex:1
	},{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		flex:1,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	},{
		header : getCommonTranslation('FROM_TIME'),
		dataIndex : 'fromTime',
		flex:1,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return timeRender(val);
			}
		}
	},{
		header : getExaminationTranslation('TILL_TIME'),
		dataIndex : 'tillTime',
		flex:1,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return timeRender(val);
			}
		}
	},{
		header : getCommonTranslation('YEAR'),
		dataIndex : 'accountingYearValue',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('LAST_DATE_ABSENTIA'),
		dataIndex : 'lastDateOfAbsentia',
		hidden:true,
		flex:1,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	},{
		header : getCommonTranslation('VENUE'),
		dataIndex : 'venue',
		flex:1
	},{
		header : getTransportTranslation('CAPACITY'),
		dataIndex : 'capacity',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('MAPPED_STUDENT_CEREMONY'),
		dataIndex : 'mappedStudentCount',
		flex:1,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return '<a href="javascript:void(0)">'+ val + '</a>';
			}
			else val;
		}
	}]
});