/**
 *  @author Shashank Jain
 */

Ext.define('Academia.view.manageCeremony.ManageCeremonyMappedProgramGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageceremonymappedprogramgrid',
	store: 'manageCeremony.ManageCeremonyApplyToGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'manageCeremony.ManageCeremonyApplyToGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'saveSequenceButton',
		text: getCommonTranslation('SAVE')
	}],
	columns: [{
		header:  getProgramandcourseTranslation("ACADEMY_LOCATION"),
		dataIndex: 'academyLocationName',
		flex:1,
		sortable:false
	},{
		header:  getCommonTranslation('PROGRAM_GROUP'),
		dataIndex: 'programGroupName',
		flex:1,
		sortable:false
	},{
		header:  getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex: 'programAndCode',
		flex:1,
		sortable:false,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(record)){
				return record.data.programAndCode.code+'/'+record.data.programAndCode.value;
			}else{
				return  '';
			}
		}
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:false
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodPrintName',
		flex:1,
		sortable:false
	},{
		header:  getProgramandcourseTranslation('TERM_SEQUENCE'),
		dataIndex: 'sequence',
		flex:1,
		sortable:false,
		/*editor: {
			xtype: 'numberfield',
			//	allowBlank: false,
			name: 'sequence',
			itemId: 'sequenceNumber',
			minValue:1,
			isChanged:false,
			maxValue: 999,
			enableKeyEvents: true,
				listeners: {
				blur: function(cmp) {
					if(cmp.isChanged){
					var record = cmp.newRecord;
					var newStore = cmp.up('grid').getStore();
					var storedata = cmp.up('grid').getStore().data.items;
					var sequenceNumber = record.get('sequence');
					var value = cmp.getValue();
					
					if(Ext.isEmpty(value)) {
						record.set('sequence', '');
					}
					storedata.forEach(function(obj){
						if(obj.get('id') != record.get('id') && obj.data['sequence'] && obj.data['sequence'] ==value){
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SEQUENCE_ALREADY_EXIST'));
							Ext.defer(function() {
								record= newStore.findRecord('id',record.get('id'));
								if(record.modified && record.modified.sequence){
									record.set('sequence', record.modified.sequence);
									record.commit();
								}else{
									record.set('sequence', '');
									record.commit();
								}
								
								record.resumeEvent('blur');
							}, 10)
							return;
						}
					});
					cmp.isChanged=false;
					}
				},change:function(cmp){
					cmp.newRecord = cmp.up('grid').getSelectionModel().getSelection()[0];
					cmp.isChanged=true;
				},
				keypress: function (field, e) {
	                // Prevent input if not a number (keyCode 48-57 for numbers 0-9)
	                // or not backspace (keyCode 8), delete (keyCode 46)
	                if (e.getKey() < 48 || e.getKey() > 57) {
	                    e.preventDefault();
	                }
	            }
			}
		},*/
	}],
	plugins: [{
		ptype: 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context) {
				editor.column.field.enable();
				return true;
			}
		}
	}]
});