/**
 * @author Deepak.Nigam
 */
Ext.define('Academia.view.manageDetention.DetainedStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.detainedstudentgrid',
    store : 'manageDetention.DetainedStduentStore',
    title : getExaminationTranslation('STUDENT_DETENTION_LIST'),
    border: true,
	reserveScrollbar:true,
    frame:false,
	selType:'checkboxmodel',
    viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock  : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store :  'manageDetention.DetainedStduentStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
    tbar: [{	
		
        xtype: 'button',
        itemId: 'btnAdd',
        text : getExaminationTranslation('DETAIN_STUDENT'),
        tooltip: getExaminationTranslation('DETAIN_STUDENT'),
        scale: CONSTANTS.BUTTONSIZE
		
	}],
    columns: [/*{
	        header:'ID',
	        dataIndex : 'id',
	        hidden:true
    	},*/{
		  	header : getExaminationTranslation('ADMISSION_CODE'),
		  	dataIndex : 'admissionCode',
		  	flex:1
       },{
            header : getExaminationTranslation('STUDENT_NAME_ID'),
	        dataIndex : 'studentName', 
	        flex:1
       },{
            header : getExaminationTranslation('ATTENDANCE_PERCENTAGE'),
	        dataIndex : 'attendancePercentage',
	        flex:1
	    },{
		  	header : getExaminationTranslation('PROGRAM'),
		  	dataIndex : 'programName',
		  	flex:1
       },{
		  	header : getExaminationTranslation('BATCH'),
		  	dataIndex : 'batchName',
		  	flex:1
       },{
		  	header : getExaminationTranslation('PERIOD'),
		  	dataIndex : 'periodName',
		  	flex:1
      },{
		  	header : getExaminationTranslation('COURSE_VARIANT'),
		  	dataIndex : 'courseVariantName',
		  	flex:1
      },{
		  	header : getExaminationTranslation('EVALUATION_EVENT'),
		  	dataIndex : 'eventName',
		  	flex:1
      }]
});