/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.managetarget.ManageTargetGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.managetargetgrid',
	store: 'managetarget.ManageTargetStore',
	title: getEnquiryTranslation('MT_LIST_OF_PROGRAMS'),
	border: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		cls: 'windowBtnPos',
		defaults: {
			labelAlign: 'top',
		},
		items: [{
			xtype: 'button',
			itemId: 'saveBtnManageTargetGridItemId',
			tooltip: getCommonTranslation('SAVE'),
			text: getCommonTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			disabled: true,
			style: {
				marginRight: '10px'
			}
		}]
	},'->',{
		xtype : 'button',
		itemId : 'exportReportItemId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		formBind:true
	}],
	columns: [{
		header: getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationPrintName',
		flex: 1,
		sortable: true,
		summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('GRAND_TOTAL');
		}
	},{
		header: getCommonTranslation('PROGRAM_GROUP'),
		dataIndex: 'programGroupName',
		flex: 1,
		sortable: true,
	}, {
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex: 1,
		sortable: true,
	}, {
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex: 1,
		sortable: true,
	}, {
		header: getEnquiryTranslation('MT_ENQUIRY_TARGET'),
		dataIndex: 'enquiryTarget',
		flex: 1,
		sortable: true,
		summaryType: 'sum',
		editor: {
			xtype: 'numberfield',
			name: 'enquiryTarget',
			itemId: 'enquiryTargetItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	}, {
		header: getEnquiryTranslation('MT_APPLICATION_TARGET'),
		dataIndex: 'applicationTarget',
		flex: 1,
		sortable: true,
		summaryType: 'sum',
		editor: {
			xtype: 'numberfield',
			name: 'applicationTarget',
			itemId: 'applicationTargetItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	}, {
		header: getEnquiryTranslation('MT_ENROLMENT_PREVIOUS_YEAR'),
		dataIndex: 'enrolmentPreviousYear',
		flex: 1,
		sortable: true,
		summaryType: 'sum',
		editor: {
			xtype: 'numberfield',
			name: 'enrolmentPreviousYear',
			itemId: 'enrolmentPreviousYearItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	}, {
		header: getEnquiryTranslation('MT_RETURNING_STUDENTS'),
		dataIndex: 'returningStudents',
		flex: 1,
		sortable: true,
		summaryType: 'sum',
		/*editor: {
            xtype: 'numberfield',
            name: 'returningStudents',
            itemId: 'returningStudentsItemId',
            maxLength: 5,
            enforceMaxLength: true,
            hideTrigger: true,
            keyNavEnabled: false,
            mouseWheelEnabled: false,
            allowExponential: false,
            allowDecimals: false
        },*/
		renderer: function(val, rec) {
			/*if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }*/
			return val;
		}
	}, {
		header: getEnquiryTranslation('MT_ENROLMENT_BUDGET'),
		dataIndex: 'enrolmentBudget',
		flex: 1,
		sortable: true,
		summaryType: 'sum',
		editor: {
			xtype: 'numberfield',
			name: 'enrolmentBudget',
			itemId: 'enrolmentBudgetItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	}, {
		header: getEnquiryTranslation('MT_REVISED_BUDGET'),
		dataIndex: 'revisedBudget',
		flex: 1,
		sortable: true,
		summaryType: 'sum',
		editor: {
			xtype: 'numberfield',
			name: 'revisedBudget',
			itemId: 'revisedBudgetItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	}, {
		header: getEnquiryTranslation('MT_ENROLMENT_TARGET'),
		dataIndex: 'enrolmentTarget',
		flex: 1,
		sortable: true,
		summaryType: 'sum',
		editor: {
			xtype: 'numberfield',
			name: 'enrolmentTarget',
			itemId: 'enrolmentTargetItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	},{
		header: getEnquiryTranslation('MT_BUILDING_CAPACITY'),
		dataIndex: 'buildingCapacity',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'numberfield',
			name: 'buildingCapacity',
			itemId: 'buildingCapacityItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	},{
		header: getEnquiryTranslation('MT_BUILDING_CAPACITY_SPECIALIST'),
		dataIndex: 'buildingCapacitySpecialist',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'numberfield',
			name: 'buildingCapacitySpecialist',
			itemId: 'buildingCapacitySpecialistItemId',
			maxLength: 5,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	}],
	plugins: [{
		ptype: 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context) {
				return true;
			}
		}
	}]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1,
	listeners: {
		beforeedit: function(editor, context, e) {}
	}
});