/*
 * @author Akshay.Kalbhor
 */
/*
 * File for adding the group item in the Advanced search criteria.
 */
Ext.define('Academia.view.messaging.systemEventMessagingRuleEditor.SearchCriteriaGroupForMessaging', {
    extend: 'Ext.form.Panel',
    alias: 'widget.searchcriteriagroupformessaging',
    cls: 'panelNoSpace cbCustomPanel',
    paddingLeft:  '0',
    marginLeft: '0',
    config: {
    	searchConfigDataSourceForMessaging: null,
        andOrComponentValue:'AND'
    },
    padding: '1 1 1 1',
    layout: {
        type: 'hbox'
    },
    cls: 'tbarWithnoSpacing',
    ui: 'tbarWithnoSpacing',
    tbar: [/*{
    		xtype: 'text',
    		text: getCommonTranslation('ADVANCEDSEARCHUSERMODULEGROUPDEFAULTTEXT')
    		},*/ {
    			xtype: 'button',
    	        itemId: 'andOrComponent',
    	        text: 'all',
    	        cls: 'CustomBodyBtnSettings',
    			enableToggle: true,
    	        pressedText: 'any',
    	    	depressedText: 'all',
    	        toggleHandler: function () {
    	    		if(this.pressed) {
    	    			this.setText(this.pressedText);
    	    			this.up('form').andOrComponentValue = 'OR'; 
    	    		} else {
    	    			this.setText(this.depressedText);
    	    			this.up('form').andOrComponentValue = 'AND';
    	    		}
    	    		this.up('form').changeLogicalOperand();
    	        }
    		}, {
    			xtype: 'text',
        		text: getCommonTranslation('ADVANCEDSEARCHUSERMODULEGROUPDEFAULTTEXTHALF')
    		},
    		'->',
    		{
		    xtype: 'button',
		    itemId: 'lineButton',
		    cls: 'CustomBodyBtnSettings',
		    text: getCommonTranslation('ADDBUTTONTEXT'),
		    tooltip: getCommonTranslation('ADD'),
		    width: 24,
		    handler: function() {
		    	var groupContainerPanel= this.up('panel');
		    	/*
		    	 * Code to remove the error class from the panel if present
		    	 */
		    	if(groupContainerPanel.hasCls('cbCustomErrorPanel')) {
		    		groupContainerPanel.removeCls('cbCustomErrorPanel');
		    	}
		    	groupContainerPanel.addSearchCriteriaLineItem(groupContainerPanel);
		    	this.up('form').changeLogicalOperand();
		    }
		
		}, {
		    xtype: 'button',
		    itemId: 'groupButton',
		    cls: 'CustomBodyBtnSettings',
		    text: getCommonTranslation('GROUPBUTTONTEXT'),
		    tooltip: getCommonTranslation('GROUPBUTTONTOOLTIP'),
		    listeners: {
		        click: function() {
			    	var groupContainerPanel= this.up('panel');
			    	/*
			    	 * Code to remove the error class from the panel if present
			    	 */
			    	if(groupContainerPanel.hasCls('cbCustomErrorPanel')) {
			    		groupContainerPanel.removeCls('cbCustomErrorPanel');
			    	}
			    	groupContainerPanel.addSearchCriteriaGroupItem(groupContainerPanel);
			    	this.up('form').changeLogicalOperand();
		        }
		    }
		}, {
		    xtype: 'button',
		    itemId: 'groupDeleteButton',
		    glyph: ICONGLYPH.DELETEGLYPH,
		    cls: 'CustomBodyBtnReject',
		    tooltip: getCommonTranslation('DELETETOOLTIP'),
		    handler: function() {
		    	var groupContainerPanel= this.up('panel');
		    	groupContainerPanel.deleteGroupItem(groupContainerPanel);
		    }
		}
    ],
      items: [{
		xtype: 'text',
		itemId: 'andOrComponent',
		minWidth: '27px',
		padding: '9 0 0 0'
	},{
        xtype: 'form',
        autoScroll: true,
        itemId: 'verticalPanel',
        cls: 'noBorderPane',
        margin: '0 0 0 0',
        padding: '0 0 0 0',
        flex: 1,
        layout: {
            type: 'vbox',
            align: 'stretch'
        }
    }],
    
    addSearchCriteriaGroupItem: function(groupContainerPanel) {
    	var verticalPanel = groupContainerPanel.down('panel#verticalPanel');
    	var groupRef = Ext.create('Academia.view.messaging.systemEventMessagingRuleEditor.SearchCriteriaGroupForMessaging', {"searchConfigDataSourceForMessaging":this.searchConfigDataSourceForMessaging});
    	/*
    	 * Adding group reference in the vertical panel
    	 */
    	verticalPanel.add(groupRef);
    	return groupRef;
    },
    
    /*
     * add search criteria
	 * STEPS TO BE FOLLOWED: 
	 * Up SearchConfig Data Source
	 * Create Table Store
	 * Add Search Criteria Line Item
	*/
    addSearchCriteriaLineItem: function(lineContainerPanel) {
    	var verticalPanel = lineContainerPanel.down('panel#verticalPanel');    	
    	var lineRef = Ext.create('Academia.view.messaging.systemEventMessagingRuleEditor.SearchCriteriaLineItemForMessaging', {"searchConfigDataSourceForMessaging":searchConfigDataSourceForMessaging});
    	lineRef.initializeComponent();
    	 verticalPanel.add(lineRef);
    },
    
    /*
     * function called from the Advanced Search Query Builder view.
     * called up on click of the search button.
     */
    getSearchCriteriaValue:function(){
    	var searchCriteriaItemContainer = this.down('panel#verticalPanel');
    	var andOrComponent = this.down('button#andOrComponent');
    	var searchCriteriaItems = searchCriteriaItemContainer.items.items;
    	var cbSearchCriteria = new Object();
    	var searchCriterias = new Array();
    	if(searchCriteriaItems.length > 0) {
        	Ext.each(searchCriteriaItems, function(item) {
        		/*
        		 * item.getSearchCriteriaValue() is a function of the line
        		 */
        		var advancedSearchCriteria = item.getSearchCriteriaValue();
        		searchCriterias.push(advancedSearchCriteria);
        	});
        	
        	if(andOrComponent.text === 'all') {
        		cbSearchCriteria.logicalOperator = 'AND';	
        	} else if (andOrComponent.text === 'any'){
        		cbSearchCriteria.logicalOperator = 'OR';
        	} else {
        		cbSearchCriteria.logicalOperator = 'AND';
        	}
        	cbSearchCriteria.type = 'LOGICAL';
        	cbSearchCriteria.searchCriterias = searchCriterias;
        	//cbSearchCriteria.visibility=true;
			//cbSearchCriteria.whetherEditable=true;
    	} else {
    		//Code to assign red border to the container
    		panel = searchCriteriaItemContainer.up('panel');
    		panel.addCls('cbCustomErrorPanel');
    		Ext.Error.raise(getErrorTranslation('CRITERIABUILDERGENERICERROR'));
    	}
    	
    	return cbSearchCriteria;
    },
    
    /*
     * function to delete/close the passed group.
     */
    deleteGroupItem: function(groupContainerPanel) {
    	var containerPanel = groupContainerPanel.up('panel');
    	if(containerPanel.xtype === 'systemeventmessagingruleeditor') {
    		showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('CANNOTDELETETHEFIRSTGROUP'));
    	} else {
    		groupContainerPanel.close();
    	} 
    	
    },
    
    /*
     * function to change the logical operand.
     */
    changeLogicalOperand: function() {
    	var buttonText = this.dockedItems.items[0].items.items[1].text;
    	var andOrComponentText = null;
    	if(buttonText == 'all') {
    		andOrComponentText = 'AND';
    	} else if(buttonText == 'any') {
    		andOrComponentText = 'OR';
    	}
    	var searchCriteriaItemContainer = this.down('panel#verticalPanel');
    	var searchCriteriaItems = searchCriteriaItemContainer.items.items;
    	
    	Ext.each(searchCriteriaItems, function(childItem) {
    		//childItem.changeLogicalComponentText(groupReference.andOrComponentValue)
    		childItem.changeLogicalComponentText(andOrComponentText);
    	});
    },
    
    changeLogicalComponentText: function(logicalOperandText) {
    	this.andOrComponentValue=logicalOperandText;
    	this.dockedItems.getAt(0).items.getAt(0).setText(logicalOperandText);
    },
    
    initializeByModel: function(searchCriteriaLogicalModel) {
    	
    	var groupReference = this;
    	var verticalPanelReference =  groupReference.down('panel#verticalPanel');
    	var searchCriteriaItems  = null;
    	if(searchCriteriaLogicalModel.data!= undefined) {
    		searchCriteriaItems = searchCriteriaLogicalModel.data.searchCriterias;
    	} else {
    		searchCriteriaItems = searchCriteriaLogicalModel.searchCriterias;
    	}
    	
    	Ext.each(searchCriteriaItems, function(searchCriteriaItem) {
    		if(searchCriteriaItem.type=== 'SQL') {
    			var lineItem = Ext.create('Academia.view.messaging.systemEventMessagingRuleEditor.SearchCriteriaLineItemForMessaging', {"searchConfigDataSourceForMessaging":searchConfigDataSourceForMessaging});
    			lineItem.createSearchLineItemByModel(searchCriteriaItem);
    			verticalPanelReference.add(lineItem);
    		} else if (searchCriteriaItem.type=== 'LOGICAL') {
    			groupReference.createSearchGroupItemByModel(searchCriteriaItem, groupReference);
    		} else {
    			Ext.error.raise(getErrorTranslation(CRITERIABUILDERGENERICERROR));
    		}
    		
    	});
    },
    
    createSearchGroupItemByModel: function(searchCriteriaGroupItem, groupReference) {
    	var group = this.addSearchCriteriaGroupItem(groupReference);
    	group.initializeByModel(searchCriteriaGroupItem);
    }

    
});