/*
 * AcademiesFormWindow view for the Academies tab.
 */
Ext.define('Academia.view.organization.academies.AcademiesFormWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.academiesFormWindow',
	title : getCommonTranslation('ACADEMY_DETAILS'),//Academy Details
	autoScroll : true,
	maxHeight : 600,
	modal : true,

	items : [ {
		xtype : 'customfieldform',
		customFieldEntity : CONSTANTS.ACADEMY_CF_DATA,
		columns : 2,
		addPosition : 6,
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		plugins : "formlabelrequired",
		items : [ {
			xtype : 'hidden',
			name : 'id'
		}, {
			xtype : 'hidden',
			name : 'version'
		}, {
			xtype : 'hidden',
			name : 'organizationId',
			value : '1'
		},
		//TODO:When Short Codes of Master Data get completed then show configured location short code with data
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'textfield',
				name : 'academyCode',
				allowBlank : false,
				fieldLabel : getCommonTranslation('ACADEMY_CODE'),
				enforceMaxLength : true,
				maxLength : 10
			}, {
				xtype : 'textfield',
				name : 'academyName',
				allowBlank : false,
				fieldLabel : getCommonTranslation('ACADEMY_NAME'),
				enforceMaxLength : true,
				maxLength : 100
			} ]
		}, {
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'customcombobox',
				name : 'academyType',
				fieldLabel : getCommonTranslation('ACADEMY_TYPE'),
				store : 'common.picklist.AcademyTypeStore',
				valueField : 'value',
				allowBlank : false,
				editable : false,
				displayField : 'name'
			}, {
				xtype : 'datefield',
				name : 'startDate',
				vtype : 'daterange',
				itemId : 'startDate',
				endDateField : 'tillDate',
				allowBlank : false,
				editable : true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				fieldLabel : getCommonTranslation('START_DATE')
			} ]
		}, {
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'datefield',
				name : 'tillDate',
				itemId : 'tillDate',
				vtype : 'daterange',
				startDateField : 'startDate',
				editable : true,
				minValue : new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				fieldLabel : getCommonTranslation('END_DATE')
			}, {
				xtype : 'statusCombo',
				allowBlank : false,
				editable : false,
				name : 'status',
				itemId:'status'
			}]
		  },{
				xtype : 'fieldcontainer',
				width : 'auto',
				defaults : {
					labelAlign : 'top',
					width : 226
				},
				layout : {
					type : 'hbox'
				},
				items : [ {
				xtype : 'textfield',
				name : 'academyAfrikaans',
				//maskRe:/^[a-zA-Z0-9\s]+$/,
				itemId:'academyAfrikaans',
				maxLength:255,
				enforceMaxLength:true,
				/*listeners : {
	                change : function(field, newValue,oldValue) {
	                    var validation=/^[a-zA-Z0-9\s]+$/;
	                    if(!validation.test(newValue) && newValue!='' ) {
	                        field.setValue(oldValue);
	                    }
	                }
	            },*/
				fieldLabel : getCommonTranslation('DISPLAY_NAME_IN_OTHER_LANGUAGE')
			} ]
		}, {
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('SAVE'),
				itemId : 'academyFormSubmitButtonId',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'academyFormCancelButtonId',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
	} ]

});