/*
 * File for the grid of ALP to children from supervision, SA and MA Tabs.
 */
Ext.define('Academia.view.organization.statutoryAccounting.ALPToChildGridSA', {
    extend: 'Ext.form.Panel',
    alias: 'widget.alptochildgridsa',
    title: getCommonTranslation('ALPTOCHILDTITLE'),
    frame: true,
    items: [{
	    xtype: 'grid',
	    itemId: 'alpToChildGridOFSA',
	    store: 'organization.AllocatedALPs',
	    columns: [{
	    	header: getCommonTranslation('PARENTSASAUMAU'),
	    	dataIndex: 'parentUnit.academyName',
	    	flex: 0.2
	    },{
	    	header: getCommonTranslation('CHILDSASAUMAU'),
	    	dataIndex: 'childUnit.academyName',
	    	flex: 0.2
	    },{
	    	header: getCommonTranslation('ACADEMY'),
	    	dataIndex: 'academy.academyName',
	    	flex: 0.2
	    },{
	    	header: getCommonTranslation('LOCATION'),
	    	dataIndex: 'location.name',
			flex: 0.1
	    }, {
	    	header: getCommonTranslation('PURPOSE'),
	    	dataIndex: 'purpose',
	    	flex: 0.1
	    }, {
	    	header: getCommonTranslation('OWNER'),
	    	dataIndex: 'owner',
	    	flex: 0.1
	    },{
	    	header: getCommonTranslation('END_DATE'),
	    	dataIndex: 'tillDate',
	    	xtype: 'datecolumn',
	    	dateFormat: 'd-m-Y',
	    	flex: 0.1,
			renderer:function(date) {
				return dateRender(date);
			}
	    }],
	    dockedItems: [{
	    	xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
	    	dock: 'bottom',
	    	displayInfo: true,
	    	store: 'organization.AllocatedALPs'
	    }]
    }]
});