/**
 * @author akshay.sharma
 * 
 * This component is used for to show window with add/edit Program Group master details. 
 */
Ext.define('Academia.view.othermasters.programGroupMaster.ProgramGroupMasterFormWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.programgroupmasterformwindow',
	modal: true,
	resizable: false,
	title: getProgramandcourseTranslation('PROGRAM_GROUP_MASTER_DETAILS'),
	margin: 0,
	items: [{
		xtype: 'form',
		itemId: 'programGroupMasterForm',
		plugins: "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			itemId: 'programGroupMaster_hidden_field',
			name: 'id'
		}, {
			xtype: 'hidden',
			name: 'version'
		}, {
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{

				xtype : 'customcombobox',
				name : 'academyLocation',
				itemId : 'academyLocationId',
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store : 'common.AcademyLocationByName',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				minChars : 3,
				typeAhead : true,
				forceSelection : true,
				hideTrigger : false,
				triggerAction : 'all',
				queryParam : 'name',
				emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig : {
					listeners : {
						beforeshow : function(
								picker) {
							picker.minWidth = picker
							.up('combobox')
							.getSize().width;
						}
					},
					loadingText : getCommonTranslation('SEARCHING'),
					emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl : function() {
						return '<div class="search-item">'
						+ '{value}'
						+ '</div>';
					}
				}

			},{
				xtype : 'customcombobox',
				name : 'programGroup',
				itemId : 'Program_Group',
				fieldLabel : getCommonTranslation('PROGRAM_GROUP_NAME'),
				store:'program.ProgramGroupStore',
				valueField : 'id',
				displayField : 'value',
				forceSelection : true,
	            editable: false,
				allowBlank : false
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				fieldLabel: getProgramandcourseTranslation('EMIS_NUMBER'),
				xtype: 'textfield',
				itemId: 'emisNumber',
				name: 'emisNumber',
				labelAlign: 'top',
				maxLength: 20,
				allowBlank: true
			}, {
				xtype: 'customcombobox',
				fieldLabel: getProgramandcourseTranslation('EMIS_PROVINCE'),
				name: 'eMISProvince',
				itemId: 'eMISProvince',
				editable: false,
				labelAlign: 'top',
				store: 'organization.CountryRegionStore1',
				displayField: 'countryRegionName',
				valueField: 'id',
				allowBlank: true
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				fieldLabel: getProgramandcourseTranslation('SCHOOL_TYPE_CODE'),
				xtype: 'textfield',
				itemId: 'schoolTypeCodeItemId',
				name: 'schoolTypeCode',
				labelAlign: 'top',
				maxLength: 50,
				allowBlank: false,
                vtype: 'NoSpaceAndSpecialCharactersWithNumberAsInput'
			}, {
				xtype: 'checkboxfield',
				name: 'boardingSchool',
				boxLabel: getProgramandcourseTranslation('WHETHER_BOARDING_SCHOOL'),
				itemId:'boardingSchool',
				inputValue : true,
				uncheckedValue: false,
				style: {
					marginTop: '25px'
				}
			}]
		}, {
			xtype: 'fieldcontainer',
		    layout: {
		        type: 'hbox'
		    },
		    defaults: {
		        labelAlign: 'top',
		        width: 226
		    },
		    items: [{
		        xtype: 'customcombobox',
		        name: 'principalId',
		        itemId: 'principalItemId',
		        fieldLabel: getProgramandcourseTranslation('PRINCIPAL'),
		        store: 'common.ActiveUserStore',
		        valueField: 'id',
		        displayField: 'valueCode',
		        labelAlign: 'top',
		        minChars: 3,
		        typeAhead: true,
		        forceSelection: true,
		        hideTrigger: false,
		        triggerAction: 'all',
		        queryParam: 'name',
		        disabled: true,
		        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		        listConfig: {
		            listeners: {
		                beforeshow: function(
		                    picker) {
		                    picker.minWidth = picker
		                        .up('combobox')
		                        .getSize().width;
		                }
		            },
		            loadingText: getCommonTranslation('SEARCHING'),
		            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		            getInnerTpl: function() {
		                return '<div class="search-item">' +
		                    '{value}' +
		                    '</div>';
		            }
		        }
		    }]
		}, {
			xtype: 'photouploadform',
			itemId: 'programGrouplogoUploadField',
		},{
			xtype:'image',
			itemId: 'programGroupImage',
			border: 1,
			style: {
				borderColor: 'black',
				borderStyle: 'solid'
			},
			width: 222,
			height: 150
		},{
			xtype: 'fieldcontainer',
			width: '100%',

			items: [{
				xtype: 'button',
				itemId: 'btnSaveProgramGroupMasterForm',
				text: getCommonTranslation('SAVE'),
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				itemId: 'btnCancelProgramGroupMasterForm',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]

	}]
});
