/**
 * @author Pravin.Surve
 * 
 * This component is used for to show window with request status master details. 
 */
Ext.define('Academia.view.othermasters.requeststatusmaster.RequestStatusMasterFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.requeststatusmasterformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('REQUEST_STATUS_MASTER'), //Request Status Master	
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'requestStatustMasterForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'requestStatustMaster_hidden_field',
            name: 'id'
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('ITEM_CODE'),
            
            name: 'code',
            allowBlank: false
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('ITEM_VALUE'),
            
            name: 'value',
            allowBlank: false
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveRequestStatustMasterForm',
                text: getCommonTranslation('SAVE'), //Submit
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelRequestStatustMasterForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});