/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.outcomebasededucation.ObeCorrelationPercentGrid', { 
	 extend: 'Ext.grid.Panel',
	    alias: 'widget.obecorrelationpercentgrid',
	    store : 'OBECorrelationLevelStore.OBECorrelationPercentGridStore',
	    border: true,
		autoScroll: false,
		refreshStoreData:true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
	    title: getExaminationTranslation('OBE_CORRELATION_PERCENT'),
	    dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'OBECorrelationLevelStore.OBECorrelationPercentGridStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
	    tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH

	    }, {
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH

	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH

	    }],
	    columns: [{
	        header: getCommonTranslation('CORRELATION_LEVEL_NAME'),
	        dataIndex: 'code',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getCommonTranslation('CORRELATION_LEVEL_PERCENTAGE'),
	        dataIndex: 'doubleValue',
	        sortable: true,
	        flex: .2
	    }]
});

