/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.BankDetails.BankDetailsWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.bankdetailswindow',
	title: getCommonTranslation('BANK_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	height:400,
	width:560,
	method: 'POST',
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226,
		},
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'hidden',
				itemId:'id',
				name:'id'
			},{
				xtype: 'textfield',
				name: 'beneficiaryName',
				itemId:'beneficiaryName',
				fieldLabel: getCommonTranslation('BENEFICIARY_NAME'),
				allowBlank: false,
				maxLength:99,
				enforceMaxLength:true
			},{
				xtype: 'textfield',
				name: 'beneficiaryNameOtherLanguage',
				itemId:'beneficiaryNameOtherLanguage',
				fieldLabel: getCommonTranslation('BENEFICIARY_NAME_OTHER_LANGUAGE'),
				allowBlank: false,
				maxLength:99,
				enforceMaxLength:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'accountNumber',
				itemId:'accountNumber',
				maskRe: /[0-9]/,
				fieldLabel: getCommonTranslation('ACCOUNT_NUMBER'),
				allowBlank: false,
				maxLength:99,
				forceMaxLength:true
			},{
				xtype: 'customcombobox',
				name: 'accountTypeId',
				itemId:'accountTypeId',
				fieldLabel: getCommonTranslation('ACCOUNT_TYPE'),
				store:Ext.create('Academia.store.user.AccountTypeStore'),
				valueField: 'id',
				displayField: 'value',
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'bankDrawnOnMasterId',
				itemId:'bankDrawnOnMasterId',
				fieldLabel: getCommonTranslation('BANK_NAME'),
				store:Ext.create('Academia.store.feeandpayment.receipts.BankNameStore'),
				valueField : 'id',
        		displayField : 'value',
        		triggerAction : 'all',
				forceSelection :true,
			    queryParam:'bankName',
	    		minChars:3,
	    	    typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			},{
				xtype: 'customcombobox',
				name: 'branchNameId',
				itemId:'branchNameId',
				fieldLabel: getCommonTranslation('BRANCH_NAME'),
				store:Ext.create('Academia.store.feeandpayment.receipts.BranchNameStore'),
				valueField : 'id',
        		displayField : 'value',
        		disabled:true,
        		triggerAction : 'all',
        		disabled : true,
				forceSelection :true,
			    queryParam:'branchName',
	    		minChars:3,
	    	    typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'ifscCodeId',
				itemId:'ifscCodeId',
				fieldLabel: getCommonTranslation('IFSC_CODE'),
				store:Ext.create('Academia.store.feeandpayment.receipts.BankIfscStore'),
				valueField: 'id',
				displayField: 'code',
				disabled:true,
				triggerAction : 'all',
				disabled : true,
				forceSelection :true,
			    queryParam:'ifscCode',
	    		minChars:3,
	    	    typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			}]
		},{
				xtype:'fieldcontainer',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtn',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]	
});