/**
 *  Disciplinary Action Grid
 */
Ext.define('Academia.view.personinfo.common.NSFAS.BursaryApplicationStatus', {
	extend : 'Ext.grid.Panel',
    alias: 'widget.bursaryapplicationstatus',
    title: getPersonModuleTranslation('BURSARY_APPLICATION_STATUS'),
    border: true,
    autoScroll: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'button',
        itemId: 'checkStatus',
        text: getCommonTranslation('CHECK_STATUS'),
        tooltip : getCommonTranslation('CHECK_STATUS'),
        ui: 'CustomBtnSubmit',
	    cls: 'x-btn x-unselectable x-btn-CustomBtnSubmit-small x-noicon x-btn-noicon x-btn-CustomBtnSubmit-small-noicon',
    }],
    columns: [{
        header: getCommonTranslation('NATIONAL_ID'),
        dataIndex: 'identification',
        sortable: false,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value 
			}                        
		}
    },  {
        header: getCommonTranslation('IDENTIFICATION_TYPE'),
        dataIndex: 'identificationType',
        sortable: false,
        flex: .2,
		
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'name',
        sortable: false,
        flex: .2,
		
    }, {
        header: getCommonTranslation('CYCLE'),
        dataIndex: 'processCycle',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('STATUS1'),
        dataIndex: 'status',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('STATUS2'),
        dataIndex: 'statusTwo',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('LM_UPDATED_ON'),
        dataIndex: 'lastUpdate',
        sortable: false,
        flex: .2,
		renderer:function(value) {
			if(!isNullOrEmpty(value)) {
				return dateRender(value)+' '+timeRender(value); 
			}  
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
                       
        // this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.NSFAS.BursaryApplicationStatusStore');
    }

});