/**
 * 
 */
var CancelledSessionDetailForCBSStore = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.CancelledSessionDetailForCBSStore');
Ext.define('Academia.view.personinfo.common.course.CancelledSessionDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.cancelledsessiondetailgrid',
	store: CancelledSessionDetailForCBSStore,
	title: getMegaMenuTranslation("CANCELLED_SESSION"),
	border: true,
	autoScroll: false,
	//selType: 'checkboxmodel',
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : CancelledSessionDetailForCBSStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	
	columns: [{
		header:  getCommonTranslation("COURSE_NAME"),
		dataIndex:'courseName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COURSE_VARIANT"),
		dataIndex:'courseVariantName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SECTION"),
		dataIndex:'sectionName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SESSION_NUMBER"),
		dataIndex: 'sessionNumber',
		flex:.1,
		sortable:true,
		
	},{
		header:  getCommonTranslation("SESSION_DATE"),
		dataIndex: 'sessionDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateFormatRender(date);
			}
		
	},{
		header:getProgramandcourseTranslation("SESSION_TIME"),
		dataIndex: 'sessionTime',
		flex:.1,
		sortable:true,
		
	},{
		header:  getCommonTranslation("FACULTY"),
		dataIndex: 'faculty',
		flex:.1,
		sortable:true,
		
	},{
		header:  getCommonTranslation("ROOM"),
		dataIndex: 'roomName',
		flex:.1,
		sortable:true,
		
	},{
		header:  getCommonTranslation("CANCELLATION_REASON"),
		dataIndex: 'reasonForSubstituteSession',
		flex:.1,
		sortable:true,
		
	}]
});
