/**
 * Schedule Details
 * @author Sachin.Bangar
 */  
Ext.define('Academia.view.personinfo.common.course.MasterScheduleDetails', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.masterscheduledetails',
    title: getMegaMenuTranslation('SP_COURSE_MASTER_SCHEDULE'),
    closable: true,
    cls: 'panelNoSpace',
    width: '100%',
    /*bodyStyle: {
        overflow: 'auto !important'
    },*/
    defaults: {
        autoHeight: true
    },
    requires: ['Ext.picker.Date', 'Ext.calendar.util.Date', 'Ext.calendar.CalendarPanel', 
               'Ext.calendar.data.MemoryCalendarStore', 'Ext.calendar.data.MemoryEventStore', 
               'Ext.calendar.data.Events', 'Ext.calendar.data.Calendars', 'Ext.calendar.form.EventWindow'],
    initComponent: function() {
        var me = this;
        me.calendarStore = Ext.create('Ext.calendar.data.MemoryCalendarStore', {
            data: Ext.calendar.data.Calendars.getData()
        });
        me.eventStore = Ext.create('Ext.calendar.data.MemoryEventStore', {});
        Ext.apply(me, {
          items:[ {
		xtype:'tabpanel',
		plain: true,
		style:{overflow:'hidden !important',margin:'0!important'},
		bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
		frame: false,
		border:false,
		items:[{
			title :getMegaMenuTranslation('TIME_TABLE_DETAIL'),     
			xtype:'panel',
			autoScroll:true,
			layout:'vbox',
			defaults:{
				width:'100%'
			},
			items : [
				{
				xtype: 'studenttimetablesearchfilter',
			   }
			,{
    			xtype : 'fieldcontainer',
    			width : '100%',
    			items : [{
    				xtype: 'button',
    				itemId: 'btnPrint',
    				text : getCommonTranslation('PRINT'),
    				buttonAlign : 'left',
    				ui : 'CustomBtnThird',
    				scale : CONSTANTS.BUTTONSIZE,
    				style:{
    					marginLeft:'10px'
    				}
    			},{
    				xtype: 'hidden',
    				itemId: 'stdSectionId'
    			}]
    		},{
                xtype: 'calendarpanel',
                itemId: 'studentMasterScheduleDetails',
                toolBarDateTitleWidth: '70%',
                layout: 'fit',
                border: true,
                width: '100%',
                height: '100%',
                minHeight: 450,
                flex:1,
                region: 'center',
				showDayView:false,
				showWeekView:true,
				showMonthView:false,
				showNavBar: false,
                eventStore: me.eventStore,
                calendarStore: me.calendarStore,
                weekViewCfg: {
		            // These settings create a fixed weekday view. 
		            // This view will only show Mon-Fri.
//		            dayCount:3,
		            
		            // Always start the view on Monday
		            
//		            startDay: 5,
		            
//		            startDayIsStatic: false,
		            
		            // NOTE: the configs below apply to any DayView or WeekView. If you wanted all day
		            // and week views to share these same settings, you could simply pass these configs
		            // in the general viewCfg. Any views that do not use them will ignore them. They are
		            // only on this view in this sample to demonstrate how they can be easily customized per view.
		            
		            // Hide the half-hour marker line
		            
//		            showHourSeparator: false,
		            
//		             Start the view at 6:00
		            
		            viewStartHour: 10,
		            // End the view at 8:00pm / 20:00
		            
		            viewEndHour: 20
		            // Default the scroll position on load to 8:00 if the body is overflowed
		            /* scrollStartHour: 8,
		            // Customize the hour (and event) heights. See the docs for details on setting this.
		            // This example will be double-height (the default is 42)
		            hourHeight: 84,
		            // Allow drag-drop, drag-create and resize of events in 10-minute increments
		            ddIncrement: 10,
		            // Since the hour blocks are double-height, we can shorten the minimum event display 
		            // height to match the ddIncrement
		            minEventDisplayMinutes: 10*/
		        }, 
            }] 
		},{
			xtype:'panel',
			title :getMegaMenuTranslation('CANCELLED_SESSION_DETAIL'),
			cls:'panelNoSpace',
			style: 'padding-bottom: 30px !important;',
			autoScroll:true,
			layout:'vbox',
			defaults:{
				width:'100%'
			},
			items:[{
				xtype: 'cancelledsessiondetail',
				
			},{
				xtype:'cancelledsessiondetailgrid',
				style:{marginTop: '15px !important'
                    }
				
			}]
		}]
	}	] ,
        });

        me.callParent(arguments);
        me.doLayout();
    }
});