/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.personinfo.common.course.ProgramAndCourseGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.programandcoursegrid',
	title: getPersonModuleTranslation('PROGRAM_COURSES'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/* tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],*/
	columns: [/*{
        header: getPersonModuleTranslation('PROGRAM'),
        dataIndex: 'programName',
        sortable:true,
        flex: 1
    },{
        header: getPersonModuleTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable:true,
        flex: 1
    },{
        header: getPersonModuleTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable:true,
        flex: 1
    },{
        header: getPersonModuleTranslation('SECTION'),
        dataIndex: 'sectionCode',
        sortable:true,
        flex: 1
    },*/ {
    	header: getPersonModuleTranslation('COURSE'),
    	dataIndex: 'courseName',
    	sortable: true,
    	flex: 1

    },{
    	header: getCommonTranslation('COURSE_VARIANTS'),
    	dataIndex: 'componentName',
    	sortable:true,
    	flex: 1
    },{
    	header: getProgramandcourseTranslation('PROGRAM_ASSOCIATED'),
    	dataIndex: 'programAssociated',
    	sortable:true,
    	flex: 1,
    	renderer: function (value) {
    		if(value>0){
    			return '<a href="#">'+value+'</a>';
    		}else{
    			return "0";
    		}
    	}
    },{
    	header: getPersonModuleTranslation('Credits'),
    	dataIndex: 'credits',
    	sortable:true,
    	flex: 1,
    	hidden: true
    },{
    	header: getPersonModuleTranslation('ALTERNATE_FACULTY'),
    	dataIndex: 'alternateFacultyName1',
    	sortable:true,
    	flex: 1

    },{
    	header: getPersonModuleTranslation('TOTAL_TOPICS'),
    	dataIndex: 'totalTopic',
    	sortable:true,
    	flex: 1,
    	renderer: function (value) {
    		if(value>0){
    			return '<a href="#">'+value+'</a>';
    		}else{
    			return "0";
    		}
    	}
    },{
    	header: getPersonModuleTranslation('ASSIGN_TOPICS'),
    	dataIndex: 'assignedTopic',
    	sortable:true,
    	flex: 1,
    	renderer: function (value) {
    		if(value>0){
    			return '<a href="#">'+value+'</a>';
    		}else{
    			return "0";
    		}
    	}
    },{
    	header: getCommonTranslation('DOCUMENTS'),
    	dataIndex: 'documents',
    	sortable:true,
    	flex: 1,
    	renderer: function (value) {
    		if(value>0){
    			return '<a href="#">'+value+'</a>';
    		}else{
    			return "0";
    		}
    	}
    }],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.course.ProgramCourseStore');
    }

});