/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.personinfo.common.course.ProgramAndCourseTreeGrid', {
	extend: 'Ext.tree.Panel',
	alias: 'widget.programandcoursetreegrid',
	title: getCommonTranslation('DETAIL_VIEW_REPORT'),
	border: true,
	rootVisible: false,
	singleExpand: false,
	reserveScrollbar: true,
	height: window.innerHeight-150,
	style: {
	    width: 'calc(97% + 10px)'
	},
	useArrows: false,
	cls: 'studentassessmentreportgrid no-tree-icon treeGrid',
	frame:false,
	rowLines: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	deferRowRender: true,
	store: 'personinfo.common.course.ProgramCourseTreeStore',
	tbar: [],
	columns: [{
		xtype: 'treecolumn',
		header: getPersonModuleTranslation('COURSE'),
		dataIndex: 'treeNode',
		flex: 1,
		renderer: function (value, r, record) {
			if(record.data.leaf){
				return record.data.courseName;
			}else{
				return value;
			}
		}

	},{
		header: getCommonTranslation('COURSE_VARIANTS'),
		dataIndex: 'componentName',
		flex: 1,
		renderer: function (value, r, record) {
			if(record.data.leaf){
				return value;
			}else{
				return "";
			}
		}
	},{
		header: getProgramandcourseTranslation('PROGRAM_ASSOCIATED'),
		dataIndex: 'programAssociated',
		flex: 1,
		renderer: function (value, r, record) {
			if(record.data.leaf){
				if(value>0){
					return '<a href="#">'+value+'</a>';
				}else{
					return "0";
				}
			}
			else{
				return "";
			}
		}
	},{
		header: getPersonModuleTranslation('Credits'),
		dataIndex: 'credits',
		flex: 1,
		hidden: true
	},{
		header: getPersonModuleTranslation('ALTERNATE_FACULTY'),
		dataIndex: 'alternateFacultyName1',
		sortable:true,
		flex: 1

	},{
		header: getPersonModuleTranslation('TOTAL_TOPICS'),
		dataIndex: 'totalTopic',
		sortable:true,
		flex: 1,
		renderer: function (value, r, record) {
			if(record.data.leaf){
				if(value>0){
					return '<a href="#">'+value+'</a>';
				}else{
					return "0";
				}
			}
			else{
				return "";
			}
		}
	},{
		header: getPersonModuleTranslation('ASSIGN_TOPICS'),
		dataIndex: 'assignedTopic',
		sortable:true,
		flex: 1,
		renderer: function (value, r, record) {
			if(record.data.leaf){
				if(value>0){
					return '<a href="#">'+value+'</a>';
				}else{
					return "0";
				}
			}
			else{
				return "";
			}
		}
	},{
		header: getCommonTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		sortable:true,
		flex: 1,
		renderer: function (value, r, record) {
			if(record.data.leaf){
				if(value>0){
					return '<a href="#">'+value+'</a>';
				}else{
					return "0";
				}
			}
			else{
				return "";
			}
		}
	}]
});