/**
 * Negative Incident Window
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.NegativeIncidentForm', {
    //extend: 'Ext.form.Panel',
//	extend:'Academia.view.common.CustomFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    customFieldEntity:CONSTANTS.INCIDENT_CF_DATA,
    customFieldEntityType:CONSTANTS.INCIDENT_CF_NEGATIVE_INCIDENT_DISPLAY_NAME,
    alias: 'widget.negativeincidentform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'negative_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            itemId : 'typeOfIncidentCombo',
            fieldLabel: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
            listeners: {
            	afterRender:function(obj){
            		//this.setAllowBlank(obj,false);
            	}
            },
            name: 'type',
            valueField: 'id',
            displayField: 'value',
            store: 'common.IncidentTypeStore',
            editable: false,
            allowBlank: false
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('INCIDENT_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId : 'incidentDate',
            name: 'incidentDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            maxValue: new Date()
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('INCIDENT_RATING'),
            
            store: 'common.IncidentRatingNegativeStore',
            valueField: 'id',
            displayField: 'value',
            //value: 'USER',
            itemId: 'incidentRating',
            name: 'incidentRating',
            allowBlank: true,
            editable: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('REPORTED_BY'),
            
            store: 'personinfo.common.disciplinaryactivity.ReportedByStore',
            valueField: 'name',
            displayField: 'value',
            value: 'USER',
            itemId: 'reportedByField',
            name: 'reportedBy',
            allowBlank: false,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            //xtype: 'livesearchcombo',
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('REPORTED_ID'),
            itemId: 'reportedByUserIdField',
            name: 'reportedByUserId',
            
            store: 'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
            enableKeyEvents  : 'true',
            queryParam:'codeOrName',
        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	minChars:3,
        	displayField: 'code', 
        	valueField: 'id',
        	triggerAction: 'all',
        	
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            allowBlank: false,
            displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["code"]]}' +
             		'</tpl>'
            ),
            listConfig: {
            	listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{value}' +
        			'</div>';
        		}
            }
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REPORTED_NAME'),
            
            itemId: 'reportedByUserNameField',
            readOnly: true,
            name: 'reportedByUserName',
            allowBlank: false
        }]
    }, {
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_ACTION'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId : 'dateOfAction',
            name: 'dateOfAction',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            maxValue: new Date()
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ACTION_TAKEN'),
            itemId : 'actionTaken',
            name: 'actionTaken',
            allowBlank: false
        }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo', 
            fieldLabel: getPersonModuleTranslation('OUTCOME'),
            itemId : 'outcomeId',
            name: 'outcome',
            allowBlank: true,
            valueField: 'id',
            displayField: 'value',
            store: 'common.OutcomeCSMStore',
            editable: false,
        }, {
        	xtype: 'nestedJsonCombo',  
            fieldLabel: getPersonModuleTranslation('PENALTY'),
            itemId : 'penaltyId',
            name: 'penalty',
            allowBlank: true,
            valueField: 'id',
            displayField: 'value',
            store:'common.PenaltyCSMStore',
            editable: false,
        }]
    }, {
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            width: 460,
            fieldLabel: getPersonModuleTranslation('COURSE_VARIENT'),
            itemId : 'courseVarientId',
            name: 'courseVarient',
            allowBlank: true,
            valueField: 'courseVariantId',
            displayField: 'courseVariantCode',
            store:'common.CourseVarientOfEnrolledStudentStore'
        }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo', 
            width: 460,                
            fieldLabel: getPersonModuleTranslation('ASSESSMENT_EVENT'),
            itemId : 'assessmentEventId',
            name: 'assessmentEvent',
            allowBlank: true,
            valueField: 'id',
            displayField: 'value',
            store:'common.AssessmentEventNegativeStore',
            disabled:true,
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 460
        },
        items: [{
            xtype: 'textareafield',
            width : 460,
            fieldLabel: getPersonModuleTranslation('INCIDENT_DETAILS'),
            name: 'incidentDetails',
            itemId : 'incidentDetails'
        }, {
            xtype: 'textareafield',
            width: 460,
            fieldLabel: getPersonModuleTranslation('REMARK'),
            name: 'remarks',
            itemId : 'remarks'
        }, {

			xtype: 'fieldcontainer',    
			layout : {
				type : 'vbox'
			},
			defaults : {
				width : 460,
				labelAlign : 'top'
			},
			items : [{
				xtype:'positiveincidentdocumentgrid',
				itemId:'positiveincidentdocumentgrid',
				hidden:true,
				style:{
					marginLeft:'0px',
				},
				flex:.1
			}]
        }]
    },{
		xtype: 'fieldcontainer',
		cls:'positveIncidentCls',
		layout : {
			type : 'vbox'
		},
		defaults : {
			width : 'auto',
			labelAlign : 'top'
		},
		items : [{
			xtype: 'checkboxfield',
			width: 'auto',
			itemId:'teacherId',
			labelAlign: 'left',
			boxLabel: getCommonTranslation('INFORM_TEACHER'),
			name: 'isTeacher',
			inputValue : true,
			uncheckedValue: false
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			itemId:'parentId',
			labelAlign: 'left',
			boxLabel: getCommonTranslation('INFORM_PARENT'),
			name: 'isParent',
			inputValue : true,
			uncheckedValue: false
		}]
	
	}, {
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'positiveincidentdocumentgrid',
			itemId:'positiveincidentdocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            itemId: 'cancelButtonId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE

        }, {
				 xtype: 'button',
				 //width:460,
				 name: 'courseSyllabus',
				 text:getCommonTranslation('UPLOAD_DOC'),
				 itemId: 'uploadPositiveIncidentItemId',
				 ui: 'CustomBtnThird',
			   	 scale : CONSTANTS.BUTTONSIZE
        }]
    }]
});