/**
 * This grid is used for student and faculty negative incident
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.NegativeIncidentGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.negativeincidentgrid',
    title: getPersonModuleTranslation('NEGATIVE_INCIDENT'),
    border: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnAddStudentsNegative',
        text: getCommonTranslation('ADD_STUDENTS'),
        tooltip: getCommonTranslation('ADD_STUDENTS'),
        disabled: true
    }],
    columns: [{
        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
        dataIndex: 'type',
        sortable: true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, 'value');
        }
    }, {
        header: getPersonModuleTranslation('INCIDENT_DATE'),
        dataIndex: 'studentIncidentDate',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
        dataIndex: 'incidentDetails',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INCIDENT_RATING'),
        dataIndex: 'incidentRating',
        sortable: true,
        flex: .2,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)) {
        		return value.value;
        	} else {
        		return '';
        	}
		}
    }, {
        header: getPersonModuleTranslation('REPORTER_NAME'),
        dataIndex: 'reportedByUserName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('STUDENTS_INVOLVED'),
        //itemId: 'employeesInvolvedItemId',
        itemId: 'studentsInvolvedItemId',
        dataIndex: 'studentsInvolved',
        sortable: true,
        flex: .2,
		renderer:function(value, meta, record){
			var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
			var portalId = baseController.getCurrentLoggedPortalId();
			if(!isNullOrEmpty(value) && portalId!=3 && portalId!=7) {	
				return '<a href=#>'+value+'<a>';
			}else if(!isNullOrEmpty(value)) {	
				return value;
			}
			return '';
		}
    }, {
        header: getPersonModuleTranslation('ACTION_TAKEN'),
        dataIndex: 'actionTaken',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('DATE_OF_ACTION'),
        dataIndex: 'studentDateOfAction',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('OUTCOME'),
        dataIndex: 'studentOutcome',
        sortable: true,
        flex: .2,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.outcome)) {
        		return record.data.outcome.value;
        	} else {
        		return '';
        	}
		}
    }, {
        header: getPersonModuleTranslation('PENALTY'),
        dataIndex: 'studentPenalty',
        sortable: true,
        flex: .2,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.penalty)) {
        		return record.data.penalty.value;
        	} else {
        		return '';
        	}
		}
    }, {
        header: getPersonModuleTranslation('COURSE_VARIENT'),
        dataIndex: 'studentCourseVarient',
        sortable: true,
        flex: .2,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.courseVarient)) {
        		return record.data.courseVarient.code;
        	} else {
        		return '';
        	}
		}
    }, {
        header: getPersonModuleTranslation('ASSESSMENT_EVENT'),
        dataIndex: 'studentAssessmentEvent',
        sortable: true,
        flex: .2,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.assessmentEvent)) {
        		return record.data.assessmentEvent.value;
        	} else {
        		return '';
        	}
		}
    }, {
        header: getCommonTranslation('REAMRK'),
        dataIndex: 'remarks',
        sortable: true,
        flex: .2
    }, {
    	header:  getPersonModuleTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		sortable:true,
		//hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.documents.length>1) {					
					return '<a href=#>'+record.data.documents.length+'<a>';
				} else if(record.data.documents.length==1) {
					return '<a href=#>'+record.data.documents[0].name+'<a>';
				} 
			}                        
		}
	}],
	listeners: {
        selectionchange: {
            fn: function(model, selected) {
                model.view.up().down('#btnAddStudentsNegative').setDisabled(!selected.length);
            },
            scope: this
        },
        afterrender: function(grid){
        	try{
        		setTimeout(function(){
        			var studentsInvolvedItemId = grid.down('#studentsInvolvedItemId');
        			var index = studentsInvolvedItemId.getIndex();
        			if(grid.itemId=="studentNegativeIncidentGrid"){
        				grid.columns[index].setText(getCommonTranslation('STUDENTS_INVOLVED'))
        			} else {
        				grid.columns[index].setText(getCommonTranslation('EMPLOYEES_INVOLVED'))
        			}
        		},300);
        	}
        	catch(e){
        		console.log("");
        	}
        }
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.disciplinaryactivity.NegativeIncidentStore');
    }

});