/**
 *  Education History Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.EducationHistoryGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.educationhistorygrid',
	title : getCommonTranslation('EDUCATION_HISTORY'),
	border : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
	}, {
		xtype : 'button',
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph : ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
	}, {
		xtype : 'button',
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls : 'view-icon'
	}, {
		xtype : 'button',
		itemId : 'btnDelete',
		cls : 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph : ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
	} ],
	plugins : [ {
		ptype : 'rowexpander',
		rowBodyTpl : [ '<tpl for="."><tpl if="!Ext.isEmpty(subjectMarkInfo)">',
		               	'<table border="1" class="educationHistoryTable">',

		               	'<col style="width:20%">',
		                '<col style="width:10%">',
		                '<thead>',
		                '<tr>',
		                        '<th>'+getPersonModuleTranslation('SUBJECT')+'</th>',
		                        '<tpl if="subjectMarkInfo[0].assessmentLevel">',
                                '<th>'+getPersonModuleTranslation('ASSESSMENT_LEVEL')+'</th>',
                                '</tpl>',
                                '<tpl if="hasMarksGrade">',
                                '<th>'+getPersonModuleTranslation('MARKS_GRADE')+'</th>',
                                '</tpl>',
		                        '<th>'+getPersonModuleTranslation('EQUIVALENT_MARKS_GRADE')+'</th>',
		                '</tr>',
		                '</thead>',
		               		'<tpl for="subjectMarkInfo">',
		               			'<tr>',
		               				'<td>{subject.value}<tpl if="!Ext.isEmpty(otherSubject)"> - {otherSubject}</tpl></td>',
		               				'<tpl if="!Ext.isEmpty(assessmentLevel)"><td>{assessmentLevel}</td><tpl else></tpl>',
		               				'<tpl if="!Ext.isEmpty(conversionMaster)">',
		               			    '<td>{conversionMaster.value}</td>',
		               			    '<tpl elseif="isMarks">',
		               			    '<td></td>',
		               			    '<tpl else>',
		               			'</tpl>',
		               				'<td>{marks}</td>',
		               			'</tr>',
		               		'</tpl>',
		               	'</table></tpl>',
		               '</tpl>' ]
	} ],
	columns : [ {
		header : getCommonTranslation('EXAM_PASSED'),
		dataIndex : 'examPassed',
		sortable : true,
		flex : .2,
		renderer: function(value){
			return columnObjRender(value,"value");
		}
	}//V2D-152739
	/*,{
		header : getPersonModuleTranslation('EXAM_BOARD'),
		dataIndex : 'examBoard',
		sortable : true,
		flex : .2,
		renderer: function(value){
			return columnObjRender(value,"value");
		}
	}*/,{
		header : getCommonTranslation('EXAM_CONDUCTED_BY_COLLAGE'),
		dataIndex : 'examConductedBy',
		sortable : true,
		flex : .2
	},{
		header : getCommonTranslation('INSTITUTE_NAME'),
		dataIndex : 'instituteName',
		sortable : true,
		flex : .2
	},{
		header : getCommonTranslation('MARKS_GRADE_OBTAINED'),
		dataIndex : 'marksOrGradeObtained',
		sortable : true,
		flex : .2
	},{
		header : getCommonTranslation('education_histories_percentage'),
		dataIndex : 'percentage',
		sortable : true,
		flex : .2
	}, {
		header : getPersonModuleTranslation('PLACE'),
		dataIndex : 'place',
		sortable : true,
		flex : .2,
		hidden : true
	}, {
		header : getCommonTranslation('YEAR_OF_EXAM'),
		dataIndex : 'yearOfExamination',
		sortable : true,
		flex : .2
	}, {
		header : getCommonTranslation('RESULT_STATUS'),
		dataIndex : 'resultStatus',
		sortable : true,
		flex : .2,
		renderer: function(value){
			return columnObjRender(value,"value");
		}
	}, {
		header : getCommonTranslation('ENROLLMENT_NUMBER'),
		dataIndex : 'enrollmentNumber',
		sortable : true,
		flex : .2
	},{
		header : getCommonTranslation('RESULT_CAPTURE_MODE'),
		dataIndex : 'resultCapturingMode',
		sortable : true,
		flex : .2
	} ],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.EducationHistoryStore');
    }

});