/**
 * @author sachin.bangar
 * Medical History Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.MedicalHistoryForm', {
    //extend: 'Ext.form.Panel',
//    extend : 'Academia.view.common.DynamicFieldForm',
	 extend : 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.medicalhistoryform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    initComponent: function() {
    	if(this.itemId==='applicantMedicalHistoryForm'){
		    Ext.apply(this,{
		    	customFieldEntity:CONSTANTS.APPLICANT_MEDICAL_HISTORY,
    		    columns: 2
		    });
		   
		}else{
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.MEDICAL_HISTORY,
        		columns:2
			});
		}
    	this.callParent(arguments);
    },
   
    items: [{
        xtype: 'hidden',
        itemId: 'medical_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('CONDITION_TYPE'),
            store: 'common.MedicalConditionTypeStore',
            valueField: 'id',
            displayField: 'value',
            name: 'conditionType',
            itemId : 'conditionType',
            editable: false,
            allowBlank: false
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('MEDICAL_CONDITION'),
            name: 'medicalCondition',
            allowBlank: false,
            itemId : 'medicalConditionId'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('SINCE_WHEN'),
            name: 'dateSince',
          //--submitFormat : CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            //allowBlank: false,
            maxValue: new Date(),
            itemId: 'dateSince'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('CONSULTING_DOCOTR'),
            //allowBlank: false,
            name: 'consultingDoctor',
            itemId: 'consultingDoctor'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'fieldcontainer',
            fieldLabel: getPersonModuleTranslation('DOCTOR_TELEPHONE_NO'),
            name: 'doctorTelephoneLabelId',
            height: 58,
            itemId: 'doctorTelephoneLabelItemId',
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'doctorTelephoneCountryCode',
                itemId: 'doctorTelephoneCountryCodeItemId',
                valueField: 'isdCode',
                displayField: 'isdCode',
                store: Ext.create('Academia.store.common.CountryStore'),
                triggerAction: 'all',
                //editable: false,
                forceSelection:true ,
                width: 70,
                minChars: 1
            }, {
                xtype: 'numberfield',
                name: 'doctorTelephoneNo',
                itemId: 'doctorTelephoneNoItemId',
                minLength: 0,
                maxLength: 11,
                enforceMaxLength: true,
                hideTrigger: true,
                keyNavEnabled: false,
                mouseWheelEnabled: false,
                allowExponential: false,
                width: 146
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 460
        },
        items: [{
            xtype: 'textareafield',
            name: 'remarks',
            itemId: 'remarks',
            fieldLabel: getPersonModuleTranslation('PRECAUTION_MEDICATION')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});