/**
 * @author Pravin.Surve
 */

Ext.define('Academia.view.personinfo.common.paymentandrefund.PaymentMadeHistoryGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.paymentmadehistorygrid',
    title: getPersonModuleTranslation('PAYMENT_MADE_HISTORY'),
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    /*tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],*/
    columns: [{
        header: getPersonModuleTranslation('PAYMENT_DATE'),
        dataIndex: 'transactionDate',
        flex: .2,
        renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		}
    },{
        header: getPersonModuleTranslation('PAYMENT_VOUCHER_NUMBER'),
        dataIndex: 'paymentVoucherNo',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('AMOUNT'),
        dataIndex: 'amount',
        flex: .2,
        renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
    }, {
        header: getPersonModuleTranslation('PAYMENT_MODE'),
        dataIndex: 'voucherMode',
        flex: .2
    },  {
        header: getPersonModuleTranslation('ADJUSTMENT_DETAILS'),
        dataIndex: 'adjustment',
        flex: .2,
        align : 'center',
        renderer: function(value){
        	return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
        }
    }, {
        header: getPersonModuleTranslation('INSTRUMENT_DETAILS'),
        dataIndex: 'instrument',
        flex: .2,
        align : 'center',
        renderer: function(obj, meta, record, rowIndex){
        	if(record.data.voucherMode == 'CASH') {
        		return getTranslation('NA');
        	} else {
        		return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
        	}	
        }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.paymentandrefund.PaymentMadeHistoryStore');
    }
});