/**
 *  @author Amit G
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerNextPaymentTermViewGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feepayernextpaymenttermviewgrid',
	border: true,
	title:getPersonModuleTranslation('PAYMENT_TERMS'),
	store : 'personinfo.common.personalinfo.FeePayerNextPaymentTermViewGridStore',
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		hidden:true,
		dataIndex:'feePlanRuleId'
	},{
		header : getAdmissionTranslation('FEE_TYPE'),
		dataIndex : 'feePlanType',
		flex : 1	  
	},{
		header : getAdmissionTranslation('FEE_NAME'),
		dataIndex : 'feePlanName',
		flex : 1	  
	},{

		header:  getPersonModuleTranslation('PAYMENT_TERM_IN_SELECTION'),
		dataIndex: 'feeRuleNameOnlyForEditAndView',
		flex:1,
		sortable: false, 
		editor: {
            xtype: 'customcombobox',
            name: 'paymentTermCombo',
            itemId: 'paymentTermCombo',
            allowBlank:false,
            valueField: 'feePlanRuleName',
            displayField: 'feePlanRuleName',
            queryMode:'local',
    		listeners: {
    			focus: function(combo) {
                	var grid = combo.up('grid');
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                	var userInfo =  Academia.model.authentication.PortalInfoModel
                	var studentId = userInfo.data.student.id;
                	Ext.Ajax.request({
						type: 'rest',
						//url: SERVERURL.PATH_FIND_SPECIFIC_FEEPLAN_RULEBYFEEPLAN,
						url: SERVERURL.FIND_SPECIFIC_FEEPLANRULE_BY_FEEPLAN_FOR_NEXTYEAR,
						params:{
							feePlanId: selectedRecord.data.feePlanId
						},
						method: 'GET',
						async: false,
						success: function(res, action) {
							getJsonList = Ext.decode(res.responseText); 
		                    var store = Ext.create('Academia.store.personinfo.common.personalinfo.FeePayerCurrentTermEditComboStore');
		                    combo.bindStore(store);
		                    //var comboStore =  selectedRecord.data.feePlanRules;
							 if(store.getRange()){
								 store.removeAll();	 
							 }
							 store.add(getJsonList);
						}
                	});
                },
                select:function(obj,record){
                	var grid = obj.up('grid')
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                	selectedRecord.set('feeRuleIdOnlyForEditAndView',record[0].data.feePlanRuleId);
                  
                }
                
            }
           
        },    
        renderer:function(value, rec, record, rowIndex, colIndex, store, view) {
        	
        	if(!isNullOrEmpty(record.data.feePlanRules) &&  !isNullOrEmpty(value))
        	{
        		return value;
        	} else {
        		meta.tdCls = 'gridInputCustomStyle';
        		return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
        	}                        
        }
	
	}],
	plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1,

	},
	listeners: {
		beforeedit:function(editor, context){			
			var formWin =Ext.ComponentQuery.query('feepayernextpaymenttermviewform')[0];
			if(formWin.isView){
				context.grid.columns[3].getEditor().setReadOnly(true);
			}else{
				context.grid.columns[3].getEditor().setReadOnly(false);
			}
		}
	}
});