/**
 * This view is used for student/faculty request pending decision
 * @author sachin.bangar
 */
Ext.define('Academia.view.personinfo.common.request.RequestPendingActionGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.requestpendingactiongrid',
	title: getPersonModuleTranslation('REQUEST_PENDING_ACTION'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
        itemId: 'quickCommentToFacultyRequestId',
        disabled: true,
        text: getFeeAndPaymentCommonTranslation('QUICK_COMMENT'),
        tooltip: getFeeAndPaymentCommonTranslation('QUICK_COMMENT')
	}],
	columns: [{
		header: getPersonModuleTranslation('REQUEST_ID'),
		dataIndex: 'REQUEST_ID',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return '<a href="#">'+ value +'</a>';
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_BY'),
		dataIndex: 'REQUEST_BY',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer: function(value){
			if(!isNullOrEmpty(value)){
				if(value.toUpperCase() == 'STUDENT'){
					return getServiceRequestTranslation('STUDENT');
				}else if(value.toUpperCase() == 'FACULTY'){
					return getServiceRequestTranslation('FACULTY');
				}else if(value.toUpperCase() =='PARENTS'){
					return getServiceRequestTranslation('PARENT');
				}
				else if(value.toUpperCase() =='STAFF'){
					return getServiceRequestTranslation('STAFF');
				}
				else if(value.toUpperCase() == 'ACADEMIC_ADMINISTRATOR'){
					return getServiceRequestTranslation('ACADEMIC_ADMINISTRATOR');
				}else{
					return value
				}
			}
			else{
				return value
			}
		}
	},{
		header: getPersonModuleTranslation('USER_NAME'),
		dataIndex: 'USER_NAME',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer: function(value){
			return value;
		}
	},{
		header: getPersonModuleTranslation('REQUESTER_NAME'),
		dataIndex: 'REQUESTER_NAME',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return value;
		}
	},{
		header: getPersonModuleTranslation('PROGRAM'),
		dataIndex: 'PROGRAM',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return value;
		}
	},{
		header: getPersonModuleTranslation('SECTION'),
		dataIndex: 'SECTION',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return value;
		}
	},{
		header: getFeeAndPaymentCommonTranslation('FATHER_NAME'),
		dataIndex: 'FATHER_NAME',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer: function(value){
			return value;
		}
	},{
		header: getPersonModuleTranslation('REQUEST_CATEGORY'),
		dataIndex: 'SERVICE_REQUEST_GROUP',
		sortable: true,
		flex: .2,
		renderer : function(value){
			if(value == 'PROGRAM'){
				value = getServiceRequestTranslation('PROGRAM');
			}else if(value == 'COURSES'){
				value = getServiceRequestTranslation('COURSES');
			}else if(value == 'COMMUNITY'){
				value = getServiceRequestTranslation('COMMUNITY');
			}else if(value == 'OTHER'){
				value = getServiceRequestTranslation('OTHER');
			}else if(value == 'LEAVE'){
				value = getServiceRequestTranslation('LEAVE');
			}else if(value == 'PROGRAM_TRANSFER'){
				value = getServiceRequestTranslation('PROGRAM_TRANSFER');
			}else if(value == 'COURSE_TRASNFER'){
				value = getServiceRequestTranslation('COURSE_TRASNFER');
			}else if(value == 'SECTION_TRASNFER'){
				value = getServiceRequestTranslation('SECTION_TRASNFER');
			}else if(value == 'CERTIFICATE'){
				value = getServiceRequestTranslation('CERTIFICATE');
			}else if(value == 'SERVICE_SUBSCRIBE_WITHDRAW'){
				value = getServiceRequestTranslation('SERVICE_SUBSCRIBE_WITHDRAW');
			}else if(value == 'FEE_CONCESSION'){
				value = getServiceRequestTranslation('FEE_CONCESSION');
			}else if(value == 'FEE_RELATED'){
				value = getServiceRequestTranslation('FEE_RELATED');
			}else if(value == 'SCHOLARSHIP'){
				value = getServiceRequestTranslation('SCHOLARSHIP');
			}else if(value == 'DEBARMENT'){
				value = getServiceRequestTranslation('DEBARMENT');
			}else if(value == 'TERMINATION'){
				value = getServiceRequestTranslation('TERMINATION');
			}else if(value == 'PROGRAM_WITHDRAWAL'){
				value = getServiceRequestTranslation('PROGRAM_WITHDRAWAL');
			}else if(value == 'FREE_FORM'){
				value = getServiceRequestTranslation('FREE_FORM');
			}else if(value == 'PERSONAL_DATA_CHANGE'){
				value = getServiceRequestTranslation('PERSONAL_DATA_CHANGE');
			}/*else if(value == 'TRANSFER'){
        		value = getServiceRequestTranslation('TRANSFER');
        	}*/else if(value == 'COURSE_TRANSFER'){
        		value = getServiceRequestTranslation('COURSE_TRANSFER');
        	}else if(value == 'SECTION_TRANSFER'){
        		value = getServiceRequestTranslation('SECTION_TRANSFER');
        	}else if(value == 'COURSE_WITHDRAWAL'){
        		value = getServiceRequestTranslation('COURSE_WITHDRAWAL');
        	}else if(value == 'STUDENT_TRANSFER'){
        		value = getServiceRequestTranslation('STUDENT_TRANSFER');
        	}else if(value == 'TRANSFER'){
        		value = getServiceRequestTranslation('TRANSFER_REQ_CAT');
        	}else if(value == 'EMPLOYEELEAVE'){
        		value = getServiceRequestTranslation('EMPLOYEELEAVE');
        	}else if(value == 'SCHOOL_LEAVING'){
        		value = getServiceRequestTranslation('SCHOOL_LEAVING');
        	}else if(value == 'GENERAL'){
        		value = getServiceRequestTranslation('GENERAL');
        	}
			return value;
		}
	}, {
		header: getPersonModuleTranslation('REQUEST_TYPE'),
		sortable: true,
		dataIndex: 'SRS_REQUEST_TYPE',
		flex: .2,
		renderer : function(value){
			if(value == 'FEE_CONCESSION'){
				value = getServiceRequestTranslation('FEE_CONCESSION');
			}else if(value == 'COURSES'){
				value = getServiceRequestTranslation('COURSES');
			}else if(value == 'COMMUNITY'){
				value = getServiceRequestTranslation('COMMUNITY');
			}else if(value == 'OTHER'){
				value = getServiceRequestTranslation('OTHER');
			}else if(value == 'LEAVE'){
				value = getServiceRequestTranslation('LEAVE');
			}else if(value == 'PROGRAM_TRANSFER'){
				value = getServiceRequestTranslation('PROGRAM_TRANSFER');
			}else if(value == 'COURSE_TRASNFER'){
				value = getServiceRequestTranslation('COURSE_TRASNFER');
			}else if(value == 'SECTION_TRASNFER'){
				value = getServiceRequestTranslation('SECTION_TRASNFER');
			}else if(value == 'CERTIFICATE'){
				value = getServiceRequestTranslation('CERTIFICATE');
			}else if(value == 'SERVICE_SUBSCRIBE_WITHDRAW'){
				value = getServiceRequestTranslation('SERVICE_SUBSCRIBE_WITHDRAW');
			}else if(value == 'FEE_CONCESSION'){
				value = getServiceRequestTranslation('FEE_CONCESSION');
			}else if(value == 'FEE_RELATED'){
				value = getServiceRequestTranslation('FEE_RELATED');
			}else if(value == 'SCHOLARSHIP'){
				value = getServiceRequestTranslation('SCHOLARSHIP');
			}else if(value == 'DEBARMENT'){
				value = getServiceRequestTranslation('DEBARMENT');
			}else if(value == 'TERMINATION'){
				value = getServiceRequestTranslation('TERMINATION');
			}else if(value == 'PROGRAM_WITHDRAWAL'){
				value = getServiceRequestTranslation('PROGRAM_WITHDRAWAL');
			}else if(value == 'FREE_FORM'){
				value = getServiceRequestTranslation('FREE_FORM');
			}else if(value == 'PERSONAL_DATA_CHANGE'){
				value = getServiceRequestTranslation('PERSONAL_DATA_CHANGE');
			}/*else if(value == 'TRANSFER'){
        		value = getServiceRequestTranslation('TRANSFER');
        	}*/else if(value == 'COURSE_TRANSFER'){
        		value = getServiceRequestTranslation('COURSE_TRANSFER');
        	}else if(value == 'SECTION_TRANSFER'){
        		value = getServiceRequestTranslation('SECTION_TRANSFER');
        	}else if(value == 'COURSE_WITHDRAWAL'){
        		value = getServiceRequestTranslation('COURSE_WITHDRAWAL');
        	}else if(value == 'STUDENT_TRANSFER'){
        		value = getServiceRequestTranslation('STUDENT_TRANSFER');
        	}else if(value == 'EMPLOYEELEAVE'){
        		value = getServiceRequestTranslation('EMPLOYEELEAVE');
        	}else if(value == 'TRANSFER'){
        		value = getServiceRequestTranslation('TRANSFER_REQ_CAT');
        	}else if(value == 'SCHOOL_LEAVING'){
        		value = getServiceRequestTranslation('SCHOOL_LEAVING');
        	}else if(value == 'HOSTEL_LEAVE'){
        		value = getServiceRequestTranslation('HOSTEL_LEAVE');
        	}
			return value;
		}
	}, {
		header: getPersonModuleTranslation('REQUEST_SUB_TYPE'),
		dataIndex: 'SUB_REQUEST_TYPE',
		sortable: true,
		hidden:true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('REQUEST_DATE'),
		dataIndex: 'REQUEST_DATE',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('SERVICE_REQUEST_STATUS'),
		dataIndex: 'SERVICE_REQUEST_STATUS',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('REMARKS'),
		dataIndex: 'REMARKS',
		sortable: true,
		flex: .2,
		renderer:function(val,rec) {
			if(rec.record.data.REQUEST_TYPE == 'TERMINATION'){
				return rec.record.data.TERMINATION_REMARK;
			}else{
				return val;
			}
		}
	},{
		header: getServiceRequestTranslation('VOLUNTARY_DOCUMENTS'),
		dataIndex: 'VAL_DOCUMENT_ID',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return '<a href="#">' + "View" + '</a>';
			}                     
		}
	},{
		header: getServiceRequestTranslation('MANDATORY_DOCUMENTS'),
		dataIndex: 'MAN_DOCUMENT_ID',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return '<a href="#">' + "View" + '</a>';
			}                     
		}
	},{
		header: getCommonTranslation('WITHDRAWAL_REASON'),
		dataIndex: 'WITHDRAWAL_REASON',
		sortable: true,
		hidden:true,
		flex: .2
	},{
		header: getCommonTranslation('APPROVAL_LETTER'),
		dataIndex: 'APPROVAL_LETTER',
		sortable: true,
		flex: .2,
		hidden: true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return '<a href="#">' + value + '</a>';
			}                     
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.request.RequestPendingActionStore');
	}
});