/**
 * @author Amit G 
 */
Ext.define('Academia.view.personinfo.dashlet.StudentDisciplinaryActivityDashlet', {
	extend : 'Academia.view.personinfo.dashlet.PersonInfoDashboardDashlet',
	alias : 'widget.studentdisciplinaryactivitydashlet',
    graphView:true,
    layout:'card',
    activeItem: 0, 
    cls:'StudentDisciplinaryActivityDashletCLS dashlet',
    loadPersonInfoDashboard :function(paramsObj){
	    var this$=this;
	    var view= this$.layout.getActiveItem();
	    if(view.xtype=='panel'){ 
	    	var studentProfile = this$.up('studentprofile');
	    	var studentId = studentProfile.getUserId();
	    	Ext.Ajax.request({
			 method: "GET",
				 type: 'rest',
				 url: SERVERURL.STUDENT_DISCIPLINARY_DASHLETCOUNT,
				 params:{
					 studentId:studentId
				 },
				 success: function(f, action) {
					 var defaultcurrncyId = Ext.JSON.decode(f.responseText);
					 var disciplinaryAction = view.down('#disciplinaryAction');
					 if(!isNullOrEmpty(disciplinaryAction)){
						 disciplinaryAction.setValue(defaultcurrncyId.disciplinaryCount); 
					 }
					 var negativeIncidents = view.down('#negativeIncidents');
					 if(!isNullOrEmpty(negativeIncidents)){
						 negativeIncidents.setValue(defaultcurrncyId.negativeIncidentCount);
					 }
					 var positiveIncidents = view.down('#positiveIncidents');
					 if(!isNullOrEmpty(positiveIncidents)){
						 positiveIncidents.setValue(defaultcurrncyId.positiveIncidentCount);
					 }
				 }
			 });
	    }
	    /*if(view.xtype=='griddashlet' && (view.itemId == 'disciplinaryActionDashletId' || view.itemId == 'negativeIncidentDashletId' || view.itemId == 'positiveIncidentDashletId')){
	    	view.getSelectionModel().deselectAll();
	    	var store= view.getStore();
	    	var getStudentProfile = this$.up('studentprofile');
	    	var personId = getStudentProfile.getPersonId();
	    	store.getProxy().extraParams = {
	    		personId: personId
	    	};
	    	store.load({
	    		callback: function(rec, operation, success) {
	    			if(rec.length==0){
	    				this$.layout.setActiveItem(4);
	    			}
	    		}
	    	});
	    }*/
	    if(view.xtype=='griddashlet'){
	    	var store= view.getStore();
	    	var extraparams;
	    	if(paramsObj !=undefined){
				extraparams=paramsObj;
			}else{
				extraparams=this$.getParams();	
			}
	    	
	    	switch (view.itemId) {
	    	case 'disciplinaryActionDashletId':
	    		this$.resetPageSetting(store);
	    		view.getSelectionModel().deselectAll();
		    	var getStudentProfile = this$.up('studentprofile');
		    	var personId = getStudentProfile.getPersonId();
		    	store.getProxy().extraParams = {
		    		personId: personId
		    	};
		    	store.load();
				break;
	    	case 'negativeIncidentDashletId':
	    		this$.resetPageSetting(store);
	    		view.getSelectionModel().deselectAll();
		    	var getStudentProfile = this$.up('studentprofile');
		    	var personId = getStudentProfile.getPersonId();
		    	store.getProxy().extraParams = {
		    		personId: personId
		    	};
		    	store.load();
				break;	
	    	case 'positiveIncidentDashletId':
	    		this$.resetPageSetting(store);
	    		view.getSelectionModel().deselectAll();
		    	var getStudentProfile = this$.up('studentprofile');
		    	var personId = getStudentProfile.getPersonId();
		    	store.getProxy().extraParams = {
		    		personId: personId
		    	};
		    	store.load();
				break;
	    	
	    	case 'disciplinaryListOfDoscumntGridId':
	    		this$.resetPageSetting(store);
				store.getProxy().extraParams = {
	    			disciplinaryActionId:extraparams.disciplinaryActionId
				};
				store.load();
				break;
	    	case 'negativeListOfDoscumntGridId':
	    		this$.resetPageSetting(store);
				store.getProxy().extraParams = {
	    			incidentId:extraparams.incidentId
				};
				store.load();
				break;
	    	case 'positiveListOfDoscumntGridId':
	    		this$.resetPageSetting(store);
				store.getProxy().extraParams = {
	    			incidentId:extraparams.incidentId
				};
				store.load();
				break;	
	    	}

	    }
	},
	defaults: {
		cls: 'horizontalScrollingFixed',
		xtype:'griddashlet'
    },
    
	items:[{
    	xtype:'panel',
    	border: true,
    	autoScroll:true,
    	layout:'hbox',
    	margin : 0,
    	cls : 'horizontalScrollingFixed',
    	width:'100%',
    	items:[{
    		xtype:'fieldcontainer',
    		//width:'98%',
    		layout:'hbox',
    		items:[{
        		xtype: 'panel',
        		cls:'disciplinaryActionCLS',
        		layout:'vbox',
    			defaults: {
    				labelAlign: 'top',
    				width: 121
    			},
        		items:[{
        		    xtype: 'label',
        		    text: getPersonModuleTranslation('DISCIPLINARY_ACTIONS'),
        		    height: 20,
        		    style: {
        		        whiteSpace: 'normal', 
        		        wordWrap: 'break-word',
        		        fontWeight: 'bold',
        		        color: '#000000'
        		    }
        		},{
        			xtype:'displayfield',
        			width: 40,
        			itemId:'disciplinaryAction',
        			name:'disciplinaryAction',
        			renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			},
        			listeners: {
        				afterrender: function(inPanel) {
        					inPanel.getEl().on("click", function(event, target) {
        						if(inPanel.getValue()>0){
        							var studentdisciplinaryactivitydashlet=inPanel.up('studentdisciplinaryactivitydashlet');
            						studentdisciplinaryactivitydashlet.getLayout().setActiveItem(1);
            							var getStudentProfile = studentdisciplinaryactivitydashlet.up('studentprofile');
            							var personId = getStudentProfile.getPersonId();
            							var store = studentdisciplinaryactivitydashlet.getLayout().getActiveItem().getStore();
            							store.getProxy().extraParams = {
            								personId : personId
            							};
            							studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();	
        						}
        				});
        				}		
        			}
        		}]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		cls:'disciplinaryActionCLS',
    			defaults: {
    				labelAlign: 'top',
    				width: 121
    			},
        		items:[{
        		    xtype: 'label',
        		    text: getPersonModuleTranslation('NEGATIVE_INCIDENTS'),
        		    height: 20,
        		    style: {
        		        whiteSpace: 'normal', 
        		        wordWrap: 'break-word',
        		        fontWeight: 'bold',
        		        color: '#000000'
        		    }
        		},{
        			xtype:'displayfield',
        			width: 40,
        			itemId:'negativeIncidents',
        			name:'negativeIncidents',
        			renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			},
        			listeners: {
        				afterrender: function(inPanel) {
        					inPanel.getEl().on("click", function(event, target) {
        						if(inPanel.getValue()>0){
        						var studentdisciplinaryactivitydashlet=inPanel.up('studentdisciplinaryactivitydashlet');
        						studentdisciplinaryactivitydashlet.getLayout().setActiveItem(2);
        							var getStudentProfile = studentdisciplinaryactivitydashlet.up('studentprofile');
        							var personId = getStudentProfile.getPersonId();
        							var store = studentdisciplinaryactivitydashlet.getLayout().getActiveItem().getStore();
        							store.getProxy().extraParams = {
        								personId : personId
        							};
        							studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
        						}
        						
        				});
        				}		
        			}
        				
        		}]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		cls:'disciplinaryActionCLS',
    			defaults: {
    				labelAlign: 'top',
    				width: 121
    			},
        		items:[{
        		    xtype: 'label',
        		    text: getPersonModuleTranslation('POSITIVE_INCIDENTS'),
        		    height: 20,
        		    style: {
        		        whiteSpace: 'normal', 
        		        wordWrap: 'break-word',
        		        fontWeight: 'bold',
        		        color: '#000000'
        		    }
        		},{
        			xtype:'displayfield',
        			width: 40,
        			itemId:'positiveIncidents',
        			name:'positiveIncidents',
        			renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			},
        			listeners: {
        				afterrender: function(inPanel) {
        					inPanel.getEl().on("click", function(event, target) {
        						if(inPanel.getValue()>0){
        						var studentdisciplinaryactivitydashlet=inPanel.up('studentdisciplinaryactivitydashlet');
        						studentdisciplinaryactivitydashlet.getLayout().setActiveItem(3);
        							var getStudentProfile = studentdisciplinaryactivitydashlet.up('studentprofile');
        							var personId = getStudentProfile.getPersonId();
        							var store = studentdisciplinaryactivitydashlet.getLayout().getActiveItem().getStore();
        							store.getProxy().extraParams = {
        								personId : personId
        							};
        							studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
        						}	
        						
        				});
        				}		
        			}
        				
        		}]
        	}
    ]}]
    },{
    	title: getPersonModuleTranslation('DISCIPLINARY_ACTION'),
    	cls:'disciplinaryActionDashletHeaderId',
    	itemId:'disciplinaryActionDashletId',
    	fields: ['person', 'details', 'incidentDate', 'actionTaken', 'dateOfAction', 'remarks','reportedByUser','reportedByUserName', 'documents','incidentType', 'disciplinaryActionDetails','customData'],
		url : SERVERURL.DISCIPLINARY_ACTION_GRIDDATA_POST,
		addPagingToolbar : true,
		columns : [{
	        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
	        dataIndex: 'incidentType',
	        sortable: true,
	        flex: .2,
	        renderer:function(value, meta, record){
				if(!isNullOrEmpty(value)) {
					return value.value; 
				}                        
			}
	    },  {
	        header: getPersonModuleTranslation('DATE_OF_INCIDENT'),
	        dataIndex: 'incidentDate',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
	        dataIndex: 'details',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('REPORTER_USER_NAME'),
	        dataIndex: 'reportedByUserName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('ACTION_TAKEN'),
	        dataIndex: 'actionTaken',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('DATE_OF_ACTION'),
	        dataIndex: 'dateOfAction',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getCommonTranslation('STUDENTS_INVOLVED'),
	        dataIndex: 'disciplinaryActionDetails',
	        sortable: true,
	        flex: .2,
			renderer:function(value, meta, record){
				if(!isNullOrEmpty(value)) {	
					if(record.data.disciplinaryActionDetails.length){
						return '<a href=#>'+record.data.disciplinaryActionDetails.length+'<a>';
					}
				}
			}
	    }, {
	        header: getPersonModuleTranslation('REMARK'),
	        dataIndex: 'remarks',
	        sortable: true,
	        flex: .2
	    }, {
			header:  getPersonModuleTranslation('DOCUMENTS'),
			dataIndex: 'documents',
			sortable:true,
			renderer:function(value, meta, record){
				if(!isNullOrEmpty(value)) {
					if(record.data.documents.length>1) {					
						return '<a href=#>'+record.data.documents.length+'<a>';
					} else if(record.data.documents.length==1) {
						return '<a href=#>'+record.data.documents[0].name+'<a>';
					} 
				}                        
			}
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				studentdisciplinaryactivitydashlet.activeTab = 1;
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(0);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
				portlet.doLayout();
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documents"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					if(record.data.documents.length == 1){
						var whetherFile = false;
						var documentId= record.data.documents["0"].id;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}} else if(record.data.documents.length > 1){
							var studentdisciplinaryactivitydashlet=grid.ownerCt.up('studentdisciplinaryactivitydashlet');
							studentdisciplinaryactivitydashlet.getLayout().setActiveItem(7);
							var selectedRecord = grid.ownerCt.getSelectionModel().getSelection()[0];
							var store = studentdisciplinaryactivitydashlet.getLayout().getActiveItem().getStore();
							var id = selectedRecord.data.id;
							if(!isNullOrEmpty(id)){
								/*store.getProxy().extraParams = {
									disciplinaryActionId : id
								};*/
								studentdisciplinaryactivitydashlet.params={
										disciplinaryActionId : id
		    					};
		    					var paramsObj={
		    							disciplinaryActionId : id
		    					};
							}
							
							//store.load();
							studentdisciplinaryactivitydashlet.loadPersonInfoDashboard(paramsObj);

						}
					}
				}else if(columnName == 'disciplinaryActionDetails') {
					if(e.target.tagName=='A'){
					var selectedRecord = grid.ownerCt.getSelectionModel().getSelection()[0];
					var storeData = selectedRecord.data.disciplinaryActionDetails;
					var newStore = Ext.create('Ext.data.Store', {
						fields: [{ name: "code" },{ name: "id" },{ name: "value" },{ name: "programName" }],
						data: storeData
					});
					var studentdisciplinaryactivitydashlet=grid.ownerCt.up('studentdisciplinaryactivitydashlet');
					studentdisciplinaryactivitydashlet.getLayout().setActiveItem(4);
					var disciplinaryActionGrid = studentdisciplinaryactivitydashlet.getLayout().getActiveItem();
					disciplinaryActionGrid.reconfigure(newStore);
					disciplinaryActionGrid.getView().refresh();
					}	
				}
			}
		}
	},{
		title: getPersonModuleTranslation('NEGATIVE_INCIDENT'),
		cls:'disciplinaryActionDashletHeaderId',
		itemId:'negativeIncidentDashletId',
		fields: ['person', 'type', 'incidentDate', 'reportedByUserId', 'reportedByUserName', 'actionTaken', 'honourName', 'remarks',
	    	'dateOfAction','incidentRating','incidentDetails','documents','studentsInvolved','uniqueIdentifier','customData'],
		url : SERVERURL.NEGATIVE_INCIDENT_GRIDDATA_POST,
		addPagingToolbar : true,
		columns : [{
	        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
	        dataIndex: 'type',
	        sortable: true,
	        flex: .2,
	        renderer : function(obj){
	        	return columnObjRender(obj, 'value');
	        }
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DATE'),
	        dataIndex: 'incidentDate',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
	        dataIndex: 'incidentDetails',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_RATING'),
	        dataIndex: 'incidentRating',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
	        	if(!isNullOrEmpty(value)) {
	        		return value.value;
	        	} else {
	        		return '';
	        	}
			}
	    }, {
	        header: getPersonModuleTranslation('REPORTER_NAME'),
	        dataIndex: 'reportedByUserName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getCommonTranslation('STUDENTS_INVOLVED'),
	        itemId: 'studentsInvolvedItemId',
	        dataIndex: 'studentsInvolved',
	        sortable: true,
	        flex: .2,
			renderer:function(value, meta, record){
				 if(!isNullOrEmpty(value)) {	
					return '<a href=#>'+value+'<a>';
				}
			}
	    }, {
	        header: getPersonModuleTranslation('ACTION_TAKEN'),
	        dataIndex: 'actionTaken',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('DATE_OF_ACTION'),
	        dataIndex: 'dateOfAction',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('REMARK'),
	        dataIndex: 'remarks',
	        sortable: true,
	        flex: .2
	    }, {
	    	header:  getPersonModuleTranslation('DOCUMENTS'),
			dataIndex: 'documents',
			sortable:true,
			//hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					if(record.data.documents.length>1) {					
						return '<a href=#>'+record.data.documents.length+'<a>';
					} else if(record.data.documents.length==1) {
						return '<a href=#>'+record.data.documents[0].name+'<a>';
					} 
				}                        
			}
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				studentdisciplinaryactivitydashlet.activeTab = 1;
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(0);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
				portlet.doLayout();
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documents"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					if(record.data.documents.length == 1){
						var whetherFile = false;
						var documentId= record.data.documents["0"].id;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}} else if(record.data.documents.length > 1){
							var studentNegativeActivityDashlet=grid.ownerCt.up('studentdisciplinaryactivitydashlet');
							studentNegativeActivityDashlet.getLayout().setActiveItem(8);
							var selectedRecord = grid.ownerCt.getSelectionModel().getSelection()[0];
							var store = studentNegativeActivityDashlet.getLayout().getActiveItem().getStore();
							var id = selectedRecord.data.id;
							if(!isNullOrEmpty(id)){
								/*store.getProxy().extraParams = {
									disciplinaryActionId : id
								};*/
								studentNegativeActivityDashlet.params={
										incidentId : id
		    					};
		    					var paramsObj={
		    							incidentId : id
		    					};
							}
							studentNegativeActivityDashlet.loadPersonInfoDashboard(paramsObj);

						}
					}
				}else if(columnName == 'studentsInvolved') {
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					Ext.Ajax.request({
			        	type: 'rest',
			        	url: SERVERURL.GET_INCIDENT_STUDENTS_INVOLVED+'?uniqueIdentifier='+record.data.uniqueIdentifier,
			        	method: 'GET',
			        	callback : function(opt, success, response){
			        		var data = Ext.decode(response.responseText);
			            	var storeData = data;
			            	var newStore = Ext.create('Ext.data.Store', {
			            		fields: [{ name: "code" },{ name: "id" },{ name: "name" },{ name: "programName" }],
			            		data: storeData
			            	});
			            	var studentdisciplinaryactivitydashlet=grid.ownerCt.up('studentdisciplinaryactivitydashlet');
							studentdisciplinaryactivitydashlet.getLayout().setActiveItem(5);
							var studentInvolveNegativeGrid = studentdisciplinaryactivitydashlet.getLayout().getActiveItem();
							newStore.pageSize = 1;
							studentInvolveNegativeGrid.reconfigure(newStore);
							studentInvolveNegativeGrid.getView().refresh();
			        	}	
					});
				}
				}	
			}
		}
	},{
		title: getPersonModuleTranslation('POSITIVE_INCIDENT'),
		cls:'disciplinaryActionDashletHeaderId',
		itemId:'positiveIncidentDashletId',
		fields: ['person', 'type', 'documents','incidentDate', 'reportedByUserId', 'reportedByUserName', 'actionTaken', 'honourName', 'remarks',
	    	'categoryOfIncident','incidentRating','incidentDetails','studentsInvolved','uniqueIdentifier','customData'],
		url : SERVERURL.POSITIVE_INCIDENT_GRIDDATA_POST,
		addPagingToolbar : true,
		columns : [{
	        header: getPersonModuleTranslation('CATEGORY_OF_INCIDENT'),
	        dataIndex: 'categoryOfIncident',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
				return value.value;
			}
	    }, {
	        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
	        dataIndex: 'type',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
				return value.value;
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DATE'),
	        dataIndex: 'incidentDate',
	        sortable: true,
	        flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
	        dataIndex: 'incidentDetails',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('HONOUR_AWARD_NAME'),
	        dataIndex: 'honourName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getPersonModuleTranslation('INCIDENT_RATING'),
	        dataIndex: 'incidentRating',
	        sortable: true,
	        flex: .2,
	        renderer:function(value,meta,record){
				return value.value;
			}
	    }, {
	        header: getPersonModuleTranslation('REPORTER_NAME'),
	        dataIndex: 'reportedByUserName',
	        sortable: true,
	        flex: .2
	    }, {
	        header: getCommonTranslation('STUDENTS_INVOLVED'),
	        itemId: 'studentsInvolvedItemId',
	        dataIndex: 'studentsInvolved',
	        sortable: true,
	        flex: .2,
	        renderer:function(value, meta, record){
	        	if(!isNullOrEmpty(value)) {	
	        		return '<a href=#>'+value+'<a>';
	        	}
	        }
	    },
	    {
	        header: getPersonModuleTranslation('REMARK'),
	        dataIndex: 'remarks',
	        sortable: true,
	        flex: .2
	    }, {
	    	header:  getPersonModuleTranslation('DOCUMENTS'),
			dataIndex: 'documents',
			sortable:true,
			//hidden:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					if(record.data.documents.length>1) {					
						return '<a href=#>'+record.data.documents.length+'<a>';
					} else if(record.data.documents.length==1) {
						return '<a href=#>'+record.data.documents[0].name+'<a>';
					} 
				}                        
			}
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				studentdisciplinaryactivitydashlet.activeTab = 1;
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(0);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
				portlet.doLayout();
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documents"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					if(record.data.documents.length == 1){
						var whetherFile = false;
						var documentId= record.data.documents["0"].id;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}} else if(record.data.documents.length > 1){
							var studentPositiveActivityDashlet=grid.ownerCt.up('studentdisciplinaryactivitydashlet');
							studentPositiveActivityDashlet.getLayout().setActiveItem(9);
							var selectedRecord = grid.ownerCt.getSelectionModel().getSelection()[0];
							var store = studentPositiveActivityDashlet.getLayout().getActiveItem().getStore();
							var id = selectedRecord.data.id;
							if(!isNullOrEmpty(id)){
								studentPositiveActivityDashlet.params={
										incidentId : id
		    					};
		    					var paramsObj={
		    							incidentId : id
		    					};
							}
							studentPositiveActivityDashlet.loadPersonInfoDashboard(paramsObj);

						}
					}
				}else if(columnName == 'studentsInvolved') {
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
					Ext.Ajax.request({
			        	type: 'rest',
			        	url: SERVERURL.GET_INCIDENT_STUDENTS_INVOLVED+'?uniqueIdentifier='+record.data.uniqueIdentifier,
			        	method: 'GET',
			        	callback : function(opt, success, response){
			        		var data = Ext.decode(response.responseText);
			            	var storeData = data;
			            	var newStore = Ext.create('Ext.data.Store', {
			            		fields: [{ name: "code" },{ name: "id" },{ name: "name" },{ name: "programName" }],
			            		data: storeData
			            	});
			            	var studentdisciplinaryactivitydashlet=grid.ownerCt.up('studentdisciplinaryactivitydashlet');
							studentdisciplinaryactivitydashlet.getLayout().setActiveItem(6);
							var studentInvolvePositiveGrid = studentdisciplinaryactivitydashlet.getLayout().getActiveItem();
							newStore.pageSize = 1;
							studentInvolvePositiveGrid.reconfigure(newStore);
							studentInvolvePositiveGrid.getView().refresh();
			        	}	
					});
				}
				}	
			}
		}
	},{
		title: getCommonTranslation('STUDENT_DETAILS'),
		cls:'disciplinaryActionDashletHeaderId',
		fields:['id','code','value','programName'],
		itemId:'disciplinaryStudentDetailGridId',
		addPagingToolbar : false,
		columns : [{
			header: getCommonTranslation('STUDENT_ID'),
			dataIndex: 'code',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'value',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
	        sortable: true,
	        flex: .2
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				Ext.each(studentdisciplinaryactivitydashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitydashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(1);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitydashlet.items.get(3).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));

			}
		}
	},{
		title: getCommonTranslation('STUDENT_DETAILS'),
		cls:'disciplinaryActionDashletHeaderId',
		fields:['id','code','value','name','programName'],
		itemId:'negativeStudentDetailGridId',
		addPagingToolbar : false,
		columns : [{
			header: getCommonTranslation('STUDENT_ID'),
			dataIndex: 'code',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'name',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
	        sortable: true,
	        flex: .2
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				Ext.each(studentdisciplinaryactivitydashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitydashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(2);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitydashlet.items.get(4).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
			}
		}
	},{
		title: getCommonTranslation('STUDENT_DETAILS'),
		cls:'disciplinaryActionDashletHeaderId',
		fields:['id','code','value','name','programName'],
		itemId:'positiveStudentDetailGridId',
		addPagingToolbar : false,
		columns : [{
			header: getCommonTranslation('STUDENT_ID'),
			dataIndex: 'code',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'name',
	        sortable: true,
	        flex: .2
		},{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
	        sortable: true,
	        flex: .2
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				Ext.each(studentdisciplinaryactivitydashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitydashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(3);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitydashlet.items.get(5).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
			}
		}
	},{
		title : getCommonTranslation('LIST_OF_DOCUMENTS'),
		fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','disciplinaryAction','serialNo'],
		cls:'disciplinaryActionDashletHeaderId',
		url : SERVERURL.DISCIPLINARY_ACTION_DASHLET_DOCUMENT_FIND,
		itemId:'disciplinaryListOfDoscumntGridId',
		addPagingToolbar : false,
		columns : [{
			header : getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			align: 'left',
			flex: 0.5,
			renderer: function(value, metaData, record, rowIndex){
				return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
			}
		},{
			header : getCommonTranslation('DOCUMENTS'),
			dataIndex : 'documentName',
			flex:1,
			renderer:function(value,rec){
				if(value){
					return "<a href='#'>"+value+"</a>";
				}
			}
		},{
			header : getCommonTranslation('UPLOADED_ON'),
			dataIndex : 'submissionDate',
			flex:1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				Ext.each(studentdisciplinaryactivitydashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitydashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(1);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitydashlet.items.get(3).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documentName"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
						var whetherFile = false;
						var documentId= record.data.documentId;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}
					}
				}
			}
		}
	},{
		title : getCommonTranslation('LIST_OF_DOCUMENTS'),
		fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','disciplinaryAction','serialNo'],
		cls:'disciplinaryActionDashletHeaderId',
		url : SERVERURL.POSITIVE_NEGATIVE_INCIDENT_DASHLET_DOCUMENT_FIND,
		itemId:'negativeListOfDoscumntGridId',
		addPagingToolbar : false,
		columns : [{
			header : getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			align: 'left',
			flex: 0.5,
			renderer: function(value, metaData, record, rowIndex){
				return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
			}
		},{
			header : getCommonTranslation('DOCUMENTS'),
			dataIndex : 'documentName',
			flex:1,
			renderer:function(value,rec){
				if(value){
					return "<a href='#'>"+value+"</a>";
				}
			}
		},{
			header : getCommonTranslation('UPLOADED_ON'),
			dataIndex : 'submissionDate',
			flex:1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				Ext.each(studentdisciplinaryactivitydashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitydashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(2);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitydashlet.items.get(4).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documentName"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
						var whetherFile = false;
						var documentId= record.data.documentId;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}
					}
				}
			}
		}
	},{
		title : getCommonTranslation('LIST_OF_DOCUMENTS'),
		fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','disciplinaryAction','serialNo'],
		cls:'disciplinaryActionDashletHeaderId',
		url : SERVERURL.POSITIVE_NEGATIVE_INCIDENT_DASHLET_DOCUMENT_FIND,
		itemId:'positiveListOfDoscumntGridId',
		addPagingToolbar : false,
		columns : [{
			header : getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			align: 'left',
			flex: 0.5,
			renderer: function(value, metaData, record, rowIndex){
				return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
			}
		},{
			header : getCommonTranslation('DOCUMENTS'),
			dataIndex : 'documentName',
			flex:1,
			renderer:function(value,rec){
				if(value){
					return "<a href='#'>"+value+"</a>";
				}
			}
		},{
			header : getCommonTranslation('UPLOADED_ON'),
			dataIndex : 'submissionDate',
			flex:1,
			renderer: function(date) {
	            return dateRender(date);
	        }
		}],
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				Ext.each(studentdisciplinaryactivitydashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						studentdisciplinaryactivitydashlet.getHeader().remove(currentHeaderTool);
					}
				});
				studentdisciplinaryactivitydashlet.addTool(Ext.create('Ext.panel.Tool',{
			         type: 'prev',
			         handler: function(btn, target, header, tool){
			        	 header.ownerCt.getLayout().setActiveItem(3);
			        	 header.remove(tool);
			        	 studentdisciplinaryactivitydashlet.params={};
			        	// reset the page param after going previous page
			        	 var itemStore = studentdisciplinaryactivitydashlet.items.get(5).getStore();
			        	 itemStore.currentPage = 1;
			        	 studentdisciplinaryactivitydashlet.loadPersonInfoDashboard();
			        	 }
				     }));
			},
			cellclick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				grid.ownerCt.getView().refresh();
				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				if(columnName == "documentName"){
					if(e.target.tagName=='A'){
					var record = grid.ownerCt.getSelectionModel().getSelection()[0];
						var whetherFile = false;
						var documentId= record.data.documentId;
						if(!isNullOrEmpty(documentId)){
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
								method: 'GET',
								callback : function(opt, success, response){
									if(response.responseText == 'true') {
										var csvForm = Ext.create('Ext.form.Panel'); 
										csvForm.getForm().submit({
											target: '_blank',
											method:'GET',
											params :{
												access_token : Ext.Ajax.defaultHeaders.access_token
											},
											headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
											url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
											standardSubmit :true
										});
									} else {
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
									}
								}
							});
						}
					}
				}
			}
		}
	},{
		xtype: 'image',
		width: '100%',
		height: '100%',
		frame : false,
		src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var studentdisciplinaryactivitydashlet=portlet.up('studentdisciplinaryactivitydashlet');
				studentdisciplinaryactivitydashlet.activeTab = 1;
			}
		}
	}]
});
