Ext.define('Academia.view.personinfo.faculty.familydetail.FacultyFamilyDetailCardTpl', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.facultyfamilydetailcardtpl',
    title: '',
	flex: 1,
	layout: {
	    type: 'vbox',
	    align: 'stretch'
	},
    columnWidth:0.5,
    border: true,
    height: 245,
    cls: 'parentgaurdiancards',
	items: [
		{
			xtype: 'panel',
			layout: 'hbox',
	    	flex: 1,
	    	cls: 'pgCardLayoutUprPnl',
	        style: 'height:130px !important',
			items:[{
				xtype: 'fieldcontainer',
				flex: 8,
				defaults: {
					labelWidth: 125,
					labelStyle: 'white-space: nowrap;width:auto'
				},
				items:[{
					xtype: 'displayfield',
					fieldLabel: getPersonModuleTranslation('NAME'),
					value: '',
					labelWidth: 40,
					name: 'pgNameField',
					fieldStyle: 'text-transform: capitalize;font-weight: bold;margin-top: -1px !important;',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getPersonModuleTranslation('EMAIL_ID'),
					value: '',
					labelWidth: 55,
					name: 'pgEmailField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getCommonTranslation('MOBILE_NO'),
					value: '',
					labelWidth: 68,
					name: 'pgMobileNoField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				}]
			},{
				xtype: 'image',
				src: 'resources/images/profile_faculty.png',
				width: 100,
				height: 120
			}]
		},
		{
			xtype: 'panel',
	    	flex: 1,
	    	cls: 'pgCardLayoutBtnPnl',
	    	layout: 'hbox',
	    	items: [{
	            xtype: 'button',
	            text: getCommonTranslation('ADD_DETAILS'),
	            itemId: 'addDetails_PG_ItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('EDIT'),
	            itemId: 'edit_PG_ItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('VIEW'),
	            itemId: 'view_PG_ItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('DELETE'),
	            itemId: 'delete_PG_ItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
		}
	]
});