/**
 * Faculty Family Detail Form
 */
Ext.define('Academia.view.personinfo.faculty.familydetail.FacultyFamilyDetailForm', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.DynamicFieldForm',
	//extend:'Academia.view.common.IdGeneratorCustomForm',
    //customFieldEntity:CONSTANTS.PARENTANDGUARDIAN_CF_DATA,
    //customFieldEntityType:CONSTANTS.PARENTANDGUARDIAN_CF_DISPLAY_NAME,
	alias: 'widget.facultyfamilydetailform',
    border: false,
    frame: false,
    plugins: "formlabelrequired",
    relatedPerson: null,
    relatedPersonUserId:null,
    getRelatedPerson: function() {
        return this.relatedPerson;
    },
    setRelatedPerson: function(relatedPerson) {
    	this.relatedPerson = relatedPerson;
    },
    getRelatedPersonUserId: function() {
        return this.relatedPersonUserId;
    },
    setRelatedPersonUserId: function(relatedPersonUserId) {
    	this.relatedPersonUserId = relatedPersonUserId;
    },
    items: [{
    	xtype: 'hidden',
    	itemId: 'pg_hidden_field',
    	name: 'id'
    },{
    	xtype: 'hidden',
    	itemId: 'old_photo_url',
    	name: 'photoUrl'
    }, {
    	xtype: 'fieldcontainer',
    	itemId : 'relationShipEmployeeField',
    	defaults: {
    		labelAlign: 'top',
    		//width: 226
    	},
    	items: [
    		{
    			xtype: 'fieldcontainer',
    			//itemId : 'relationShipEmployeeField',
    			layout: 'hbox',
    			defaults: {
    				labelAlign: 'top',
    				width: 226
    			},
    			items: [{
    				xtype: 'customcombobox',
    				fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
    				name: 'relationship',
    				valueField: 'name',
    				displayField: 'value',
    				itemId: 'relationShipField',
    				store: 'common.FacultyFamilyRelationshipStore',
    				editable: false,
    				allowBlank: false
    			},{
    				xtype: 'form',
    				itemId: 'parentImageInnerForm',
    				border: false,
    				frame: false,
    				cls: 'panelNoSpace',
    				plugins: "formlabelrequired",
    				defaults: {
    					labelAlign: 'top',
    					width: 226
    				},
    				items:[
    					{
    						xtype: 'filefield',
    						fieldLabel: getCommonTranslation('PHOTO_IMAGE_SIZE'),
    						buttonText: getPersonModuleTranslation('UPLOAD'),
    						itemId: 'photoFileImageParent',
    						ui: 'CustomBtnSubmit',
    						name: 'photoFileImageParent'
    					}]
    			},{
					xtype:'button',
					text:'Snapshot',
					style: {
		    			marginTop: '32px !important',
		    		},
					itemId: 'snapshotCaptureBtnItemId',
					name:'snapshotCaptureBtn',
					ui: 'CustomBtnSubmit',
					listeners:{
						click : function(){
							var formWindow = Ext.widget('imagecapturewindow');
							formWindow.show();
						}
					}
				}]
    		},{
    			xtype: 'fieldcontainer',
    			//itemId : 'relationShipEmployeeField',
    			layout: 'hbox',
    			defaults: {
    				labelAlign: 'top',
    				width: 226
    			},
    			items: [{
    				xtype: 'textfield',
    				fieldLabel: getPersonModuleTranslation('ENTER_ID'),
    				name: 'externalEmployeeId',
    				allowBlank: true,
    				itemId :'relationshipUserExternal'
    			},{
    				xtype: 'checkboxfield',
    				width: 'auto',
    				itemId: 'isEmployeeOrganisation',
    				labelAlign: 'right',
    				boxLabel: getPersonModuleTranslation('IN_ORGANISATION'),
    				name: 'isEmployeeOfOrganization',
    				inputValue: true,
    				uncheckedValue: false,
    				style: {
		    			marginTop: '25px !important',
		    		},
    				width: 226
    			},{
    		        xtype: 'fieldcontainer',
    		        layout: 'hbox',
    		        itemId : 'employeeIdSearchField',
    		        defaults: {
    		            labelAlign: 'top',
    		            width: 226
    		        },
    		        hidden : true,
    		        disabled : true,
    		        items: [{
    		            xtype: 'textfield',
    		            itemId: 'employeeIdField',
    		            emptyText: getCommonTranslation('ENTER_USER_CODE'),
    		            fieldLabel: getPersonModuleTranslation('ENTER_ID'),
    		            name: 'userCode',
    		            width: 160
    		        },{
    		            xtype: 'button',
    		            text: getCommonTranslation('SEARCH'),
    		            itemId: 'searchButtonId',
    		            ui: 'CustomBtnSubmit',
    		            style: {
    		                marginTop: '30px'
    		            },
    		            scale: CONSTANTS.BUTTONSIZE
    		        }]
    		    }]
    		}]
    }, {
    	xtype : 'form',
    	itemId : 'parentGuardianInfoItemField',
    	margin : '0px',
    	items : [{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			labelAlign: 'top',
    			width: 226
    		},
    		items: [{
    			xtype: 'nestedJsonCombo',
    			fieldLabel: getCommonTranslation('SALUTATION'),
    			itemId :'salutationId',
    			name: 'salutation',
    			store: 'common.SalutationStore',
    			valueField: 'id',
    			displayField: 'salutationName',
    			allowBlank: false,
    			editable: false
    		}, {
    			xtype: 'textfield',
    			fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
    			vtype: 'NospaceAsInputFrench',
    			name: 'firstName',
    			allowBlank: false,
    			itemId :'firstName',
    			maxLength : 100
    		},{
    			xtype: 'textfield',
    			fieldLabel: getPersonModuleTranslation('MIDDLE_NAME'),
    			name: 'middleName',
    			itemId :'middleName',
    			maxLength : 53
    		}]
    	}, {
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			labelAlign: 'top',
    			width: 226
    		},
    		items: [{
    			xtype: 'textfield',
    			fieldLabel: getPersonModuleTranslation('LAST_NAME'),
    			vtype: 'NospaceAsInputFrench',
    			name: 'lastName',
    			allowBlank: false,
    			itemId:'lastName',
    			maxLength : 100
    		},{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('GENDER'), //Gender
                name: 'gender',
                itemId: 'genderCombo',
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                store: 'common.GenderTypeStore',
                editable: false
    		},{
    			xtype: 'datefield',
    			fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
    			name: 'birthDate',
    			itemId: 'birthDate',
    			//--submitFormat : CONSTANTS.DATE_FORMAT,
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			allowBlank: true,
    			maxValue: new Date()
    		}]
    	}, {
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			labelAlign: 'top',
    			width: 226
    		},
    		items: [{
    			xtype: 'textfield',
    			itemId : 'primaryeEmailId',
    			fieldLabel: getPersonModuleTranslation('EMAIL_ID'),
    			name: 'emailId',
    			vtype: 'email',
    			allowBlank: false,
    			maxLength : 100
    		},{
    			xtype: 'customcombobox',
    			itemId: 'maritalStatusCombo',
    			fieldLabel: getPersonModuleTranslation('MARITAL_STATUS'),
//  			readOnly : true,
    			queryMode: 'local',
    			store: 'common.MaritalStatusStore',
    			valueField: 'id',
    			displayField: 'value',
    			name: 'maritalStatus',
    			itemId: 'maritalStatus',
    			editable: false,
    			listeners: {
    				render : function(combo){
    					var store = combo.getStore();
    					store.load();
    				}
    			}
    		}, {
    			xtype: 'numberfield',
    			fieldLabel: getPersonModuleTranslation('FAMILY_INCOME'),
    			name: 'personalIncome',
    			itemId: 'personalIncome',
    			minValue: 0,
    			maxLength : 10,
    			allowBlank: true
    		}]
    	}, {
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			labelAlign: 'top',
    			width: 226
    		},
    		items: [{
    			xtype: 'customcombobox',
    			fieldLabel: getCommonTranslation('BLOOD_GROUP'),
    			itemId: 'bloodGroup',
    			name: 'bloodGroup',
    			store: 'enquiry.studentDetail.BloodGroupStore',
    			valueField: 'id',
    			displayField: 'value',
    			editable: false,
    			allowBlank: true
    		},{
    			xtype: 'textfield',
    			fieldLabel: getPersonModuleTranslation('VEHICLE_LICENSE_PLATE_NO'),
    			name: 'vehicleLicenseNo',
    			itemId : 'vehicleLicenseNo',
    			maxLength : 45,
    			//vtype: 'NospaceAsInput',
    			//vtype : 'NoSpaceAndSpecialCharactersAsInput',
    			allowBlank: true,
    			maxLength : 45
    		},{
    			xtype: 'textfield',
    			fieldLabel: getPersonModuleTranslation('AWARD_RECEIVED'),
    			//vtype: 'NospaceAsInput',
    			//vtype : 'NoSpaceAndSpecialCharactersAsInput',
    			name: 'awardRecived',
    			itemId: 'awardReceived',
    			maxLength : 100,
    			allowBlank: true
    		}]
    	}, 
    	{
    		xtype: 'fieldset',
    		itemId : 'contactFieldSet',
    		defaults: {
    			labelAlign: 'top'
    		},
    		style: {
    			marginTop: '40px !important',
    			marginLeft : '-5px',
    			marginBottom: '0px',
    		},
    		title: getAdmissionTranslation('CONTACT_INFORMATION'), // Contact Information
    		items: [{
    			html: '<i>'+getPersonModuleTranslation('PLEASE_ENTER_ATLEAST_MOBILE_NO_OR_PHONE_NO_MSG')+'</i>'+'<span class="required" style="color:red"> *</span>',
    			margin: 0
    		},
    		{
    			xtype: 'fieldcontainer',
    			layout: 'hbox',
    			items: [{
    				xtype: 'fieldcontainer',
    				layout: 'vbox',
    				items: [{
    					xtype: 'fieldcontainer',
    					itemId : 'parentGuardianMobileField',
    					fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
    					layout: 'hbox',
    					labelAlign: 'top',
    					defaults: {
    						labelAlign: 'top',
    						width: 226
    					},
    					items: [{
    						xtype: 'combo',
    						name: 'mobileCountryCode',
    						itemId: 'mobileCountryCode',
    						valueField: 'isdCode',
    						displayField: 'isdCode',
    						store: 'common.CountryStore',
    						triggerAction: 'all',
    						forceSelection: true,
    						minChars: 1,
    						width: 70
    					}, {
    						xtype: 'numberfield',
    						itemId: 'cellNo',
    						name: 'mobileNumber',
    					    minLength: 0,
    						maxLength: 15,
    						enforceMaxLength : true,
    						hideTrigger: true,
    						keyNavEnabled: false,
//  						allowBlank: false,
    						mouseWheelEnabled: false,
    						width: 141
    					}]
    				},{
    					xtype: 'fieldcontainer',
    					labelAlign: 'top',
    					layout : {
    						type : 'hbox'
    					},
    					style: {
    		    			marginTop: '30px !important'
    		    		},
    					items : [{
    						xtype: 'checkboxfield',
    						itemId : 'isMobUseForCommunicationField',
    						labelAlign: 'right',
    						region: 'south',
    						height:45,
    						  cls:'checkBoxCstmLabel',
    						boxLabel: getPersonModuleTranslation('USE_MOBILE_FOR_COMMUNICATION'),
    						name: 'isMobUseForCommunication',
    						inputValue: true,
    						uncheckedValue: false
    					}]
    				}]
    			},
    			{
    				xtype: 'fieldcontainer',
    				layout: 'vbox',
    				items: [{
    					xtype: 'fieldcontainer',
    					fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),
    					itemId : 'phoneNumberFieldContainerId',
    					labelAlign: 'top',
    					layout : {
    						type : 'hbox'
    					},
    					items : [{
    						xtype : 'customcombobox',
    						hiddenName : 'phoneNumber1',
    						valueField : 'isdCode',
    						displayField : 'isdCode',
    						store:'common.CountryStore',
    						//queryMode: 'local',
    						triggerAction : 'all',
    						name : 'phoneCountryCode',
    						itemId : 'phoneCountryCode',
    						editable : false,
    					//	forceSelection: true,
    						width: 90
    					}, {
    						xtype : 'numberfield',
    						name : 'phoneAreaCode',
    						width: 110,
    						maxLength: 5,
    						enforceMaxLength : true,
    						// To Remove spinner buttons, and arrow key and mouse wheel listeners
    						hideTrigger: true,
    						keyNavEnabled: false,
    						mouseWheelEnabled: false,
    						allowExponential:false
    					}, {
    						xtype : 'numberfield',
    						itemId : 'phoneNoField',
    						name : 'phoneNo',
    						maxLength: 10,
    						enforceMaxLength : true,
    						// To Remove spinner buttons, and arrow key and mouse wheel listeners
    						hideTrigger: true,
    						width: 230,
    						keyNavEnabled: false,
    						mouseWheelEnabled: false,
    						allowExponential:false
    					} ]
    				}, {
    					xtype: 'fieldcontainer',
    					labelAlign: 'top',
    					layout : {
    						type : 'hbox'
    					},
    					style: {
    		    			marginTop: '30px !important'
    		    		},
    					items : [{
    						xtype: 'checkboxfield',
    						itemId : 'isPhoneUseForCommunicationField',
    						labelAlign: 'right',
    						region: 'south',
    						height:45,
    						 cls:'checkBoxCstmLabel',
    						boxLabel: getPersonModuleTranslation('USE_PHONE_FOR_COMMUNICATION'),
    						name: 'isPhoneUseForCommunication',
    						inputValue: true,
    						uncheckedValue: false
    					}]
    				}]
    			}]
    		}]
    	},
    	{
    		xtype: 'fieldcontainer',
    		itemId : 'alternateMobileField',
    		fieldLabel: getCommonTranslation('ADDRESS_ALTERNATE_MOBILE_NO'),
    		layout: 'hbox',
    		labelAlign: 'top',
    		defaults: {
    			labelAlign: 'top',
    			width: 226
    		},
    		items: [{
    			xtype: 'combo',
    			name: 'alternateMobileCountryCode',
    			itemId: 'alternateMobileCountryCode',
    			valueField: 'isdCode',
    			displayField: 'isdCode',
    			store: 'common.CountryStore',
    			triggerAction: 'all',
    			//editable: false,
    			minChars: 1,
    			forceSelection: true,
    			width: 70
    		}, {
    			xtype: 'numberfield',
    			itemId: 'alternateMobileNo',
    			name: 'alternateMobileNo',
    			minLength: 0,
    			maxLength: 15,
    			enforceMaxLength : true,
    			hideTrigger: true,
    			keyNavEnabled: false,
    			mouseWheelEnabled: false,
    			width: 141
    		}]
    	}, {
    		xtype: 'fieldcontainer',
    		//fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),
//  		hidden : true,
//  		disabled:true, 
    		width: 400,
    		labelAlign: 'top',
    		layout : {
    			type : 'hbox'
    		},
    		items : [{
    			xtype: 'checkboxfield',
    			itemId : 'isAlternateMobUseForCommunicationField',
    			labelAlign: 'right',
    			region: 'south',
    			cls:'checkBoxCstmLabel',
    			height:45,
    			/*style: {
    				marginTop: '25px',
    				marginLeft:'5px'
    			},*/
    			boxLabel: getPersonModuleTranslation('USE_ALTERNATE_MOBILE_FOR_COMMUNICATION'),
    			name: 'isAlternateMobUseForCommunication',
    			inputValue: true,
    			uncheckedValue: false
    		}]
    	},
    	{
    		xtype: 'fieldset',
    		itemId : 'educationFieldSet',
    		defaults: {
    			labelAlign: 'top'
    		},
    		style: {
    			marginTop: '30px !important',
    			marginLeft : '-5px'
    		},
    		title: getEnquiryTranslation('EDUCATION_DETAILS'), // Education Details
    		items: [{
        		xtype: 'fieldcontainer',
        		layout: 'hbox',
    			defaults: {
        			labelAlign: 'top',
        			width: 226
        		},
        		items : [{
        			xtype: 'textfield',
        			fieldLabel: getPersonModuleTranslation('HIGHEST_QUALIFICATION'),
        			name: 'highestEducation',
        			itemId: 'highestQualification',
        			maxLength : 100,
        			allowBlank: true
        		},{
        			xtype: 'customcombobox',
        			fieldLabel: getCommonTranslation('YEAR_OF_EXAM'),
        			name: 'yearOfExam',
        			itemId: 'yearItemId',
        			editable: false,
        			store: Ext.create('Academia.store.personinfo.common.pasthistory.ApplicantEducationYearStore'),
        			displayField: 'value',
        			valueField: 'id',
        			queryMode: 'local',
        			width: 226
        		}]
        	}]
    	},
    	{
    		xtype: 'fieldset',
    		itemId : 'workExperienceFieldSet',
    		defaults: {
    			labelAlign: 'top'
    		},
    		style: {
    			marginTop: '30px !important',
    			marginLeft : '-5px'
    		},
    		title: getPersonModuleTranslation('WORK_EXPERIENCE'), // Education Details
    		items: [{
    			xtype: 'fieldcontainer',
    			layout: 'hbox',
    			defaults: {
        			labelAlign: 'top',
        			width: 226
        		},
    			items : [{
    				xtype: 'textfield',
    				fieldLabel: getPersonModuleTranslation('OCCUPATION'),
    				name: 'occupation',
    				itemId: 'occupation',
    				maxLength : 100,
    				allowBlank: true
    			},{
    				xtype: 'textfield',
    				fieldLabel: getEnquiryTranslation('COMPANY_NAME'),
    				name: 'companyName',
    				itemId: 'companyName',
    				maxLength : 100,
    				allowBlank: true
    			}]
    		},{
        		xtype: 'fieldcontainer',
        		layout: 'hbox',
        		//itemId : 'parentGuardianEmailField',
        		defaults: {
        			labelAlign: 'top',
        			width: 226
        		},
        		items: [{
        			xtype: 'textfield',
        			fieldLabel: getPersonModuleTranslation('DESIGNATION'),
        			itemId:'designationCombo',
        			name : 'designation',
        			maxLength : 45
        			//allowBlank: false,
        		},{
					xtype : 'numberfield',
					itemId : 'yearOfExperience',
					name : 'yearOfExperience',
					fieldLabel: getCBTranslation('staffs_yearsOfExperience'),
					maxLength: 4,
					enforceMaxLength : true,
					decimalPrecision:1,
					enableKeyEvents:true,
					// To Remove spinner buttons, and arrow key and mouse wheel listeners
					hideTrigger: true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					allowExponential:false
				}]
        	}]
    	},
    	{
    		xtype: 'fieldcontainer',
    		itemId : 'emergencyContactField',
    		layout: 'hbox',
    		labelAlign: 'top',
    		width: 400,
    		defaults: {
    			labelAlign: 'top',
    			//width: 226
    		},
    		items: [{
    			xtype: 'checkboxfield',
    			itemId : 'isEmergencyContactField',
    			labelAlign: 'right',
    			region: 'south',
    			boxLabel: getPersonModuleTranslation('IS_AN_EMERGENCY_CONTACT'),
    			name: 'isEmergencyContact',
    			height:45,
    			cls:'checkBoxCstmLabel',
    			checked:true,
    			inputValue: true,
    			uncheckedValue: false
    		}]
    	}]
    }, {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	itemId : 'parentGuardianButtonField',

    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE

    	}]
    }]
});