Ext.define('Academia.view.personinfo.student.FindStudentForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.findstudentform',
    title: getPersonModuleTranslation('FIND_STUDENT'),
    collapsible: true,
    frame: true,
    items: [{
        xtype: 'form',
        itemId: 'findStudentForm',
        method: 'POST',
        layout: 'vbox',
        standardSubmit: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('ADMISSION_NUMBER'),
                
                name: 'admissionNumber'
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('STUDENT_ID'),
                
                name: 'studentId'

            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('SELECT_NAME'),
                
                store : 'common.SelectNameComboStore',
                editable : false,
                name: 'selectedNameField',
                itemId: 'selectedNameField',
                valueField: 'id',
                displayField: 'value',
                value: 'firstName'
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
                
                itemId: 'selectedName',
                name: 'selectedName'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getPersonModuleTranslation('VIEW_PROFILE'),
                itemId: 'viewProfileButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});