/**
 * @author <a href="vidhi.shah@serosoft.in">Vidhi Shah</a>
 *
 */
Ext.define('Academia.view.personinfo.student.PostDocInfoForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.postdocinfoform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'student_post_doc_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('CONTRACT_START_DATE'),
            itemId: 'contractStartDateItemId',
            name: 'contractStartDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: true,
            vtype : 'daterange',
            endDateField : 'contractEndDateItemId'
        },{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('CONTRACT_END_DATE'),
            itemId: 'contractEndDateItemId',
            name: 'contractEndDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: true,
            vtype : 'daterange',
            startDateField : 'contractStartDateItemId'
        },{
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('POST_DOC_QUALILFICATION_NAME'),            
            itemId: 'qualificationNameItemId',
            name: 'qualificationName',
            allowBlank: true,
            maxLength:100
        }, {
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('POST_DOC_QUALILFICATION_INSTITUTION'),            
            itemId: 'qualificationInstitutionItemId',
            name: 'qualificationInstitution',
            allowBlank: true,
            maxLength:100
        }]
    
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },

        items: [{      
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('OBTAINED_DOCTORATE_FIELD_OF_STUDY'),
            store: 'common.ProgramCesmClassificationStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'obtainedDoctorateFieldOfStudyItemId',
            name: 'obtainedDoctorateFieldOfStudy',
            allowBlank: true,
            editable: false
        },{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DOCTORATE_OBTAINED_DATE'),
            itemId: 'doctorateObtainedDateItemId',
            name: 'doctorateObtainedDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: true,
            vtype : 'daterange'
        },{
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('POST_DOC_FIELD_OF_STUDY'),
            store: 'common.ProgramCesmClassificationStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'postDocFieldOfStudyItemId',
            name: 'postDocFieldOfStudy',
            allowBlank: true,
            editable: false
        },{
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('POST_DOC_DEPARTMENT'),
            store: Ext.create('Academia.store.department.DepartmentUserAcademyLocationWiseStore'),
            valueField: 'id',
            displayField: 'value',
            itemId: 'departmentItemId',
            name: 'department',
            allowBlank: true,
            editable: false
        }]
    }, {
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_ONE'),
            store: 'common.FinancialResourceStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceOneItemId',
            name: 'financialResourceOne',
            allowBlank: true,
            editable: false
        },
        {
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_ONE_NAME'),
            store: Ext.create('Academia.store.common.FinancialResourceChildStore'),
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceChildOneItemId',
            name: 'financialResourceChildOne',
            allowBlank: true,
            editable: false,
            disabled:true
        },
        {
			xtype: 'numberfield',
			name: 'financialResourceOneAmount',
			itemId : 'financialResourceOneAmountId',
			fieldLabel: getPersonModuleTranslation('FINANCIAL_SOURCE_ONE_AMOUNT'),
			allowBlank: true,
			minLength: 0,
			maxLength: 15,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowBlank: false,
        }],
    },
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items:[{       	
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_TWO'),
            store: 'common.FinancialResourceStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceTwoItemId',
            name: 'financialResourceTwo',
            allowBlank: true,
            editable: false
        },
        {
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_TWO_NAME'),
            store: Ext.create('Academia.store.common.FinancialResourceChildStore'),
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceChildTwoItemId',
            name: 'financialResourceChildTwo',
            allowBlank: true,
            editable: false,
            disabled:true
        },
        {
			xtype: 'numberfield',
			name: 'financialResourceTwoAmount',
			itemId : 'financialResourceTwoAmountId',
			fieldLabel: getPersonModuleTranslation('FINANCIAL_SOURCE_TWO_AMOUNT'),
			allowBlank: true,
			minLength: 0,
			maxLength: 15,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowBlank: true,
        }]
        },
        { xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items:[{
        	
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_THREE'),
            store: 'common.FinancialResourceStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceThreeItemId',
            name: 'financialResourceThree',
            allowBlank: true,
            editable: false
        },
        {
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_THREE_NAME'),
            store: Ext.create('Academia.store.common.FinancialResourceChildStore'),
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceChildThreeItemId',
            name: 'financialResourceChildThree',
            allowBlank: true,
            editable: false,
            disabled:true
        },
        {
			xtype: 'numberfield',
			name: 'financialResourceThreeAmount',
			itemId : 'financialResourceThreeAmountId',
			fieldLabel: getPersonModuleTranslation('FINANCIAL_SOURCE_THREE_AMOUNT'),
			allowBlank: true,
			minLength: 0,
			maxLength: 15,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowBlank: true,
        }]
        },
        {
        	xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items:[{
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_FOUR'),
            store: 'common.FinancialResourceStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceFourItemId',
            name: 'financialResourceFour',
            allowBlank: true,
            editable: false
        },
        {
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FINANCIAL_RESOURCE_FOUR_NAME'),
            store: Ext.create('Academia.store.common.FinancialResourceChildStore'),
            valueField: 'id',
            displayField: 'value',
            itemId: 'financialResourceChildFourItemId',
            name: 'financialResourceChildFour',
            allowBlank: true,
            editable: false,
            disabled:true
        },
        {
			xtype: 'numberfield',
			name: 'financialResourceFourAmount',
			itemId : 'financialResourceFourAmountId',
			fieldLabel: getPersonModuleTranslation('FINANCIAL_SOURCE_FOUR_AMOUNT'),
			allowBlank: true,
			minLength: 0,
			maxLength: 15,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowBlank: true,
        },]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_TERMINATION'),
            itemId: 'dateOfTermination',
            name: 'dateOfTermination',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
        },{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('AUDIT_DATE'),
            itemId: 'auditDateItemId',
            name: 'auditDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            vtype : 'daterange'
        },{
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AUDIT_ID'),            
            itemId: 'auditIdItemId',
            name: 'auditId',
            readOnly : true,
            allowBlank: false
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'postdocinfodocumentgrid',
			itemId:'postdocinfodocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadPostDocItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
