/**
 * @author Deepak.Nigam
 */
Ext.define(
	'Academia.view.personinfo.student.StudentEnrollmentGenerationView',{
		extend : 'Ext.form.Panel',
		alias : 'widget.studentenrollmentgenerationview',
		plugins : "formlabelrequired",
		frame : false,
		border : false,
		method : 'POST',
		autoScroll : false,
		margin: 10,
		bodyStyle : {
			margin : CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
		},
		standardSubmit : false,
		items : [ {
			xtype : 'panel',
			items : [ {
				xtype : 'form',
				// cls:'customSearchPanel',
				title : getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'),
				collapsed : false,
				frame : true,
				margin : 0,
				items : [

				{
					xtype : 'fieldcontainer',
					layout : 'vbox',
					items : [
				{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top',
						width : 226
					},
					items : [
							{
								xtype : 'customcombobox',
								name : 'programId',
								itemId : 'programId',
								fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
								store : 'common.ProgramByAcAndLoIdStore',
								//editable : false,
								valueField : 'id',
								displayField : 'valueCode',
								allowBlank : true,
								queryParam:'programName',
								//queryMode : 'local',
								typeAhead : false,
					            forceSelection:true,
					            //hideTrigger:false,
					            //triggerAction: 'all',
					    	    //anyMatch : true,
					            minChars:3,
					            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					            listConfig: {
									  listeners: {
											beforeshow: function(picker) {
												picker.minWidth = picker.up('combobox').getSize().width;
											}
										},
						                loadingText: getCommonTranslation('SEARCHING'),
						                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						                getInnerTpl: function() {
						                    return '<div class="search-item">' +
						                    '{code} / {value}'  +
						                    '</div>';
						                }
						            }
							},
							{
								xtype : 'customcombobox',
								name : 'batchId',
								itemId : 'batchId',
								fieldLabel : getPersonModuleTranslation('BATCH'),
								store : 'program.programbatchdetail.BatchStore',
								disabled : true,
								editable : false,
								queryMode : 'local',
								displayField : 'value',
								valueField : 'id',
								allowBlank : false
							},
							{
								xtype : 'customcombobox',
								itemId : 'periodId',
								name : 'periodId',
								fieldLabel : getPersonModuleTranslation('PERIOD'),
								disabled : true,
								editable : false,
								store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
								displayField : 'value',
								valueField : 'id',
								queryMode : 'local',
								allowBlank : false
							} ]
				},
				{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top',
						width : 226
					},
					items : [
							{
								xtype : 'textfield',
								name : 'collegeNo',
								itemId : 'collegeNo',
								fieldLabel : getPersonModuleTranslation('COLLEGE_NO'),
								allowBlank : false
							},
							{
								xtype : 'numberfield',
								name : 'padding',
								itemId : 'paddingId',
								fieldLabel : getPersonModuleTranslation('PADDING'),
								minValue : 1,
								allowBlank : false
							},
							{
								xtype : 'numberfield',
								name : 'start',
								itemId : 'generationStartId',
								fieldLabel : 'Start',
								minValue : 0,
								allowBlank : false
							} ]
				},
				{
					xtype : 'fieldcontainer',
					width : '100%',
					items : [
							{
								xtype : 'button',
								text : getPersonModuleTranslation('GENERATE_ENROLLMENT'),
								itemId : 'generateEnrollmentButtonId',
								buttonAlign : 'right',
								ui : 'CustomBtnSubmit',
								scale : CONSTANTS.BUTTONSIZE,
								formBind : true
							},
							{
								xtype : 'button',
								itemId : 'resetBtn',
								text : getCommonTranslation("RESET"),
								ui : 'CustomBtnCancel',
								scale : CONSTANTS.BUTTONSIZE
							} ]
				} ]
				} ]
			} ]
		} ]
});