/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.StudentHoldReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentholdreportgrid',
	store: 'student.managehold.StudentReportHoldGridStore',
	title: getCommonTranslation("SEARCHRESULTSGRIDHEADER"),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	frame:false,
	//refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.managehold.StudentReportHoldGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'holdReportRemoveHold',
		tooltip: getCommonTranslation('REMOVE_HOLD'),
		text: getCommonTranslation('REMOVE_HOLD')
     },{
	    xtype: 'button',
	    itemId: 'deleteHold',
	    tooltip: getCommonTranslation('DELETE_HOLD'),
	    text: getCommonTranslation('DELETE_HOLD')
     },{
		xtype: 'button',
		itemId: 'sendMessageBtn',
		tooltip: getCommonTranslation('SEND_MESSAGE'),
		 text: getCommonTranslation('SEND_MESSAGE')
	}],
	columns: [{
		header:  getCommonTranslation("ACADEMY_LOCATION"),
		dataIndex:'academyName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("PROGRAM"),
		dataIndex:'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("BATCH"),
		dataIndex:'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("PERIOD"),
		dataIndex:'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("STUDENT_ID_NAME"),
		dataIndex:'studentCode',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return record.data.studentCode+"/"+record.data.studentPrintName;
			}
		}
	},{
		header:  getCommonTranslation("SEAT_TYPE"),
		dataIndex:'seatTypeName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOLD_CATEGORY_NAME"),
		dataIndex:'holdCategoryName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOLD_SUB_CATEGORY_NAME"),
		dataIndex:'subHoldCategoryName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("APPLY_HOLD_AT"),
		dataIndex:'applyholdType',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			var val;
			if(value=='COURSE_ENROLLMENT'){
				val =getCommonTranslation("COURSE_ENROLLMENT");
			}else if(value=='PROGRAM_BATCH_SECTION_ENROLLMENT'){
             	val =getCommonTranslation("PROGRAM_BATCH_SECTION_ENROLLMENT");
            }else if(value=='RESULT_PUBLISH'){
				val =getCommonTranslation("RESULT_PUBLISH");
			}else if(value=='HALL_TICKET_PUBLISH'){
				val =getCommonTranslation("HALL_TICKET_PUBLISH");
			}else if(value=='PROMOTION'){
				val =getCommonTranslation("PROMOTION");
			}else if(value=='COMMUNICATION_HOLD'){
				val =getCommonTranslation("COMMUNICATION_HOLD");
			}else if(value=='PORTAL_ACCESS'){
				val =getCommonTranslation("PORTAL_ACCESS");	
			}else if(value=='STUDENT_TRANSFER_REQUEST'){
				val =getCommonTranslation("STUDENT_TRANSFER_REQUEST");
				
			}
			
			if(value=='PORTAL_ACCESS'){
				val=getCommonTranslation('PORTAL_ACCESS');
            }
			return val;
		}
	},{
		header:  getCommonTranslation("APPLIED_DATE"),
		dataIndex:'holdAppliedDate',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(record.data.holdAppliedDate);
		}
	},{
		header:  getCommonTranslation("REMOVAL_DATE"),
		dataIndex:'holdRemovalDate',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(record.data.holdRemovalDate);
		}
	},{
		header:  getCommonTranslation("APPLIED_BY"),
		dataIndex:'holdAppliedBy',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("REMOVAL_BY"),
		dataIndex:'holdRemovalBy',
		flex:.1,
		sortable:true
	}]
});