/**
 *  Raghavendra.Soni
 */

Ext.define('Academia.view.personinfo.student.StudentListStudentProgramTransferWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentliststudentprogramtransferwindow',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('PROGRAM_TRANSFER'),
	maxHeight:600,
	height: 480,
	maxWidth: 800,
	width: 800,
	items: [{
		xtype: 'grid',
		store: Ext.create('Ext.data.ArrayStore', {
		    fields: [
		       'academyLocation', 'programGroupName', 'programName', 'batchName', 'seatName', 'programId', 'batchId'
		    ]
		}),
	    title: getCommonTranslation('CURRENT_APPLICATION_PROGRAM'),
	    border: true,
	    autoScroll: false,
	    frame: false,
	    viewConfig: {
	        stripeRows: CONSTANTS.STRIPEROWS,
	        deferEmptyText: false,
	        emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	    },
	    enableColumnHide: false,
	    columns: [{
	    	header : getCommonTranslation('ACADEMY'),
	    	dataIndex:'academyLocation', 
	    	flex: 1
	    },{
	    	header : getCommonTranslation('PROGRAM_GROUP'),
	    	dataIndex:'programGroupName', 
	    	flex: 0.5
	    },{
	    	header : getCommonTranslation('PROGRAM'),
	    	dataIndex:'programName', 
	    	flex: 0.5
	    },{
	    	header : getCommonTranslation('BATCH'),
	    	dataIndex:'batchName', 
	    	flex: 0.5
	    },{
	    	header : getCommonTranslation('SEAT_TYPE'),
	    	dataIndex:'seatName', 
	    	flex: 0.5
	    }
	    ]
	},{
		xtype: 'studentliststudentprogramtransferform'
	}]
});