/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.StudentManageHoldGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentmanageholdgrid',
	store: 'student.managehold.StudentManageHoldGridStore',
	title: getCommonTranslation("LIST_OF_HOLD"),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.managehold.StudentManageHoldGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getCommonTranslation('APPLY_TO'),
			itemId: 'applyHold',
		},{
			text: getCommonTranslation('HOLD_SUB_CATEGORY'),
			itemId: 'holdSubCategory',
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header:  getCommonTranslation("HOLD_CATEGORY_CODE"),
		dataIndex:'holdCatCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOLD_CATEGORY_NAME"),
		dataIndex:'holdCatName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOLD_SUB_CATEGORY"),
		dataIndex: 'subHoldCatCount',
		flex:.1,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return '<a href="#">' +value+ '</a>';
			}                        
		}
	},{
		header:  getCommonTranslation("HOLD_MAPPED_PROGRAM"),
		dataIndex: 'mappedProgramHoldCount',
		flex:.1,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return '<a href="#">' +value+ '</a>';
			}                        
		}
	},{
		header:  getCommonTranslation("STATUS"),
		dataIndex: 'isActive',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			var val;
			if(value==true){
				val =getCommonTranslation("ACTIVE");
			}else if(value==false){
				val =getCommonTranslation("INACTIVE");
			}
			return val;
		}
	}]
});
