/**
 * @author swapnil.patil
 */
Ext.define('Academia.view.personinfo.student.StudentProgressGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentprogressgrid',
	refreshStoreData:true,
	store : 'student.report.StudentProgressReportGridStore',
	title : getCommonTranslation('PHYSICAL_GROWTH_REPORT'),
	border: true,
	frame:false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.StudentProgressReportGridStore',
			emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns : [ {
		header : getCommonTranslation('DATE'),
		dataIndex : 'updateDate',
		flex : .3,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getCommonTranslation('MONTH'),
		dataIndex : 'monthName',
		flex : .3
	}, {
		header : getCommonTranslation('YEAR'),
		dataIndex : 'yearName',
		flex : .2,
		sortable : true,
		hidden : true
	}, {
		header : getCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('AGE'),
		dataIndex : 'age',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('GENDER'),
		dataIndex : 'genderCSM',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('PROGRAM_CATEGORY'),
		dataIndex : 'programCategory',
		sortable : true,
		flex : .2,
		hidden : true
	}, {
		header : getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'programGroup',
		sortable : true,
		flex : .2,
		hidden : true
	},{
		header : getCommonTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		sortable : true,
		flex : .2
	}, {
		header : getCommonTranslation('BATCH_NAME'),
		dataIndex : 'batchName',
		sortable : true,
		flex : .2
	}, {
		header : getCommonTranslation('PERIOD_NAME'),
		dataIndex : 'periodName',
		sortable : true,
		flex : .2
	}, {
		header : getCommonTranslation('HEIGHT'),
		dataIndex : 'height',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('WEIGHT'),
		dataIndex : 'weight',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('HEIGHT_AVG'),
		dataIndex : 'heightAvg',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('WEIGHT_AVG'),
		dataIndex : 'weightAvg',
		flex : .2,
		sortable : true
	} ]
});