Ext.define('Academia.view.personinfo.student.StudentRequestQuickSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentrequestquicksearch',
    title: getPersonModuleTranslation('QUICK_SEARCH'),
    cls : 'panelNoSpace',
	autoScroll : true,
    items: [{
        xtype: 'form',
        itemId: 'studentRequestForm',
        collapsible: true,
        frame: true,
        height: '30%',
        title: getPersonModuleTranslation('QUICK_SEARCH'),
        defaults: {
            labelAlign: 'top'
        },
        standardSubmit: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('REQUEST_ID'),
                name: 'requestId'
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('REQUEST_NAME'),
                name: 'requestName'
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('REQUESTOR_TYPE'),
                name: 'requestorType'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('REQUEST_CATEGORY'),
                editable: false,
                name: 'requestType',
//                store: 'common.ProgramStore',
                valueField: 'id',
                displayField: 'value'
            }, {
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('REQUEST_TYPE'),
                editable: false,
                name: 'requestSubType',
//                store: 'common.ProgramStore',
                valueField: 'id',
                displayField: 'value'
            }, {
                xtype: 'statusCombo',
                name: 'status',
                value: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'numberfield',
                fieldLabel: getPersonModuleTranslation('BEYOND_SLA'),
                
                name: 'beyondSLA',
                minValue :1
            },{
                xtype: 'numberfield',
                fieldLabel: getPersonModuleTranslation('PENDING_SINCE'),
                
                name: 'pendingSince',
                minValue :1
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'studentListSearchButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }, {
        xtype: 'form',
        itemId : 'resultGridForm',
        width: '100%',
        items: [{
            xtype: 'searchresultgrid',
            itemId: 'studentRequestGrid'
        }]
    }]
});