/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.placement.createcompany.CreateCompanyFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.createcompanyfilter',
	autoScroll:false,
	frame: false,
		cls:'customSearchPanel',
		standardSubmit: false,
		plugins : "formlabelrequired",
	    items: [{
	            xtype: 'fieldcontainer',
	            layout: 'hbox',
	            defaults: {
	                labelAlign: 'top',
	                width: 226
	            },
	            items: [{
	               
					xtype: 'customcombobox',
					name:'companyId',
					itemId: 'companyId',
					store:'placement.createcompany.CompanyCodeSearchStore',
					fieldLabel: getPlacementTranslation('COMPANY_NAME_AND_CODE'),
					displayField: 'valueCode',
					valueField: 'id',
					queryParam:'companyNameOrCode',
					minChars:3,
					typeAhead:false,
		            hideTrigger:false,
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		          // triggerAction: '',
		            forceSelection:true,
		            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		            enableKeyEvents  : 'true',
					  listConfig: {
					      listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			            
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'  +
			                    '</div>';
			                }
			            }
				

				
	            }, {
					xtype: 'customcombobox',
					name: 'locationId',
					itemId: 'locationId',
					fieldLabel: getPlacementTranslation('LOCATION_CODE_NAME'),
					store: 'placement.createcompany.LocationCodeSearchStore',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'companyLocationOrCode',
					//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					  triggerAction: 'all',
					hideTrigger:false,
					listConfig: {
			                listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
		                    '{code} / {value}'  +
							'</div>';
						}
					}
	            },
	            {
	            	 xtype: 'customcombobox',
	            	 name:'status',
	                 itemId: 'companyStatus',
	                 fieldLabel: getPlacementTranslation('COMPANY_STATUS'),
	                 value:true,
	                 store: 'common.StatusComboStore',
	                 itemId: 'companyStatus',
	                 valueField: 'value',
	                 forceSelection:true,
	                 editable:false,
	                 displayField: 'name'
	            }
	            
	            ]
	        }, {
	        	xtype : 'fieldcontainer',
				width : 'auto',
				cls : 'windowBtnPos',
				items : [ {
					xtype : 'button',
					text : getCommonTranslation('SEARCH'),
					itemId : 'searchButtonId',
					buttonAlign : 'left',
					ui : 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				}, {
					xtype: 'button',
					text : getCommonTranslation('RESET'),
					itemId : 'resetButtonId',
					buttonAlign : 'left',
					ui : 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				} ]
			}]
	});
