/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show contact person details in form  
 */
Ext.define('Academia.view.placement.createcompany.PlacementContactPersonDetails', {
	extend : 'Ext.window.Window',
	alias : 'widget.placementcontactpersondetailswindow',
	title:getCommonTranslation('CONTACT_PERSON_DETAILS'),
	autoScroll: true,
	modal : true,
	items: [{
	        xtype: 'form',
	        itemId: 'addContactform',
	        method: 'POST',
	        standardSubmit: false,
	        plugins : "formlabelrequired",  
	        autoScroll: true,
	        layout: {
	                type: 'vbox'
	            },
	        defaults: {
	                labelAlign: 'top',
	                //margin:10,
	                width: 226
	            },
	items : [{
    		xtype : 'hidden',
    		name : 'contactPersonId',
    		itemId :'AddContactId'
        },{
     	   xtype: 'hidden',
           name: 'sponserId',
           itemId : 'Outer_hidden'
       },{
        	xtype : 'hidden',
    		name : 'version'
        },{
    	    xtype: 'fieldcontainer',
    	    width: 'auto',
    	    defaults: {
    	    	labelAlign: 'top',
    	    	width: 226
    	    },
    	    layout: {
    		type: 'hbox'
    	    },
    	    items: [{
	            xtype: 'textfield',
	            name: 'contactName',
	            fieldLabel: getCommonTranslation('NAME'), //Name
	            allowBlank: false,
	            maxLength: 100,
//	            vtype:'NospaceAsInput'
	            vtype:'spaceAndSpecialCharactersAsInput'
	        },{
	            xtype: 'textfield',
	            name: 'designation',
	            fieldLabel: getCommonTranslation('DESIGNATION'), //Designation
	            allowBlank: false,
	            maxLength: 25,
//	            vtype:'NospaceAsInput'
	            vtype:'spaceAndSpecialCharactersAsInput'
	        }]
    	}, {
		xtype : 'textareafield',
		fieldLabel : getCommonTranslation('ADDRESS'),
		emptyText : getCommonTranslation('ENTER_ADDRESS'),
		name : 'addressText',
		allowBlank:false,
		width: 460,
		vtype:'NospaceAsInput'
	},{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        		xtype : 'nestedJsonCombo',
        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
        		hiddenName : 'country',
        		itemId : 'countryId',
        		emptyText : getCommonTranslation('ADDRESS_SELECT_COUNTRY'),
        		store:'common.CountryStore',
        		valueField : 'id',
        		displayField : 'countryName',
        		name : 'country',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false,
				queryMode: 'local'
        	}, {
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//        		name : 'genericField1',
        		itemId : 'parentCountryRegionId',
        		store:'organization.CountryRegionStore',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'parentCountryRegion',
    			queryParam:'regionName',   		 
        		//editable : false,
        		//valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false,
				typeAhead : false,
				hideTrigger:false,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryRegionName}'  +
		                    '</div>';
		                }
		            }
        	}]},{
	      xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
    		xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
    		hiddenName : 'city',
    		itemId : 'cityId',
//    		store:'organization.CityStore',
    		store:'organization.CityByCountryRegion',
    		valueField : 'id',
//    		displayField : 'cityName',
    		displayField : 'value',
    		name : 'city',
			queryParam: 'searchText',   		 
    		//editable : false,    
    		//valueNotFoundText:"",        		
			forceSelection :true,
			allowBlank:false,
			typeAhead : false,
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
    	},{
    		xtype : 'textfield',
    		fieldLabel : getCommonTranslation('PINCODE'),
//    		hiddenName : 'pincode',
    		itemId : 'pincodeId',
    		name : 'pincode',
    		minValue : 0,
    		maxLength: 8,
    		maskRe:/^[a-zA-Z0-9\s]+$/,
      	    /*mouseWheelEnabled :false,
      	    hideTrigger :true,
      	    allowExponential:false,
      	    allowDecimals:false,*/
//			allowBlank:false
    	}]
	    }, {
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	   
	}, {
		xtype: 'fieldcontainer',
	    width: 'auto',
		fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
		allowBlank:false,
		layout : {
			type : 'hbox'
		},
		defaults: {
			enforceMaxLength : true,
			labelAlign: 'top',
			width: 226
			//cls:'inputInRow'
		},
		items : [ {
			xtype : 'customcombobox',
			hiddenName : 'phoneNumber1',
			emptyText : getCommonTranslation('ADDRESS_COUNTRY_CODE'),			
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			name : 'phoneCountryCode',
			itemId : 'phoneCountryCode',
			editable : false,			
			width: 108
		}, {
			xtype : 'numberfield',
			name : 'code',
			emptyText : getCommonTranslation('ADDRESS_AREA_CODE'),
			name : 'phoneAreaCode',
			width: 108,
			maxLength: 5,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false
		}, {
			xtype : 'numberfield',
			itemId : 'phoneNoField',
			name : 'phoneNo',
			emptyText : getCommonTranslation('ADDRESS_PHONE_NUMBER'),
			maxLength: 15,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        enforceMaxLength : true
		} ]
	}, {
	    	xtype: 'fieldcontainer',
		    width: 'auto',
	    	fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
		defaults: {
			enforceMaxLength : true,
			maxLength: 10,
			labelAlign: 'top',
			width: 226
		},
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'customcombobox',
			name : 'cellCountryCode',
			itemId : 'cellCountryCode',
			emptyText : getCommonTranslation('ADDRESS_COUNTRY_CODE'),	
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			editable : false,
			width: 108
		}, {
			xtype : 'numberfield',
			name : 'cellNo',
			emptyText : getCommonTranslation('ADDRESS_PHONE_NUMBER'),
			minLength: 6,
			maxLength: 11,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        enforceMaxLength : true
		} ]
	}, {
		xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [ {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
            		name : 'primaryeEmailId',
            		emptyText : getCommonTranslation('ADDRESS_ENTER_EMAIL'),
            		vtype: 'email',
            		allowBlank: false
            	}, {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
            		name : 'alternateEmailId',
            		emptyText : getCommonTranslation('ADDRESS_ENTER_EMAIL'),
            		vtype: 'email',
            		allowBlank: true
            	}]
	      },{
                    xtype: 'fieldcontainer',
                    
                    items: [{
                        xtype: 'button',
                        itemId: 'btnSaveContactForm',
                        text: getCommonTranslation('SAVE'), //Submit
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true
                    }, {
                        xtype: 'button',
                        itemId: 'btnCancelContactForm',
                        text: getCommonTranslation('CANCEL'), //Cancel
                        ui: 'CustomBtnCancel',
                        scale: CONSTANTS.BUTTONSIZE
                    }]
                }]
	 }]
});
