/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.placement.placementjob.JobPostingDocumentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.jobpostingdocumentgrid',
    store: 'placement.placementjob.JobPostingDocumentStore',
    border: true,
    autoScroll: true,
    cls:'removeGridHorizontalScrollCls',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('DOCMENT_NAME'),
        dataIndex: 'documentName',
        flex: 1,
        sortable:false,
        renderer: function(value, rec) {
        	var doc = rec.record.data.document;
            if (!isNullOrEmpty(doc)) {
                return '<a href="#">' + doc.name + '</a>';
            } else {
                return value;
            }
        }
    }]
});