/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.placement.placementjob.PlacementJobLocationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementjoblocationgrid',
	store: 'placement.placementjob.PlacementJobLocationStore',
	title: getPlacementTranslation('JOB_LOCATIONS'),
	border: true,
	autoScroll: false,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementjob.PlacementJobLocationStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_LOCATION_NAME'),
		dataIndex: 'placementJobLocationMaster',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_COORDINATOR'),
		dataIndex: 'coordinator',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_DESIGNATION'),
		dataIndex: 'placementDesignation',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_NO_OF_POSITIONS'),
		dataIndex: 'noOfPosition',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_LOCATION_SALARY_PACKAGE'),
		dataIndex: 'placementSalaryRange',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}
	}]
});

